<?php

namespace BaseTheme\Basics;

class Shortcodes extends Basics {

	public static function register() {
		add_shortcode( 'image', array( static::class, 'image' ) );
		add_shortcode( 'display_image', array( static::class, 'image' ) );
		add_shortcode( 'fa-icon', array( static::class, 'FontAwesomeIcon' ) );
		add_shortcode( 'whitespace', array( static::class, 'whitespace' ) );
		add_shortcode( 'read-more', array( static::class, 'readMoreButton' ) );
		add_shortcode( 'read_more_button', array( static::class, 'readMoreButton' ) );
	}

	/**
	 * Display an attachment image.
	 *
	 * @param array|string $atts List of attributes added to the shortcode.
	 *
	 * @return string
	 */
	public static function image( $atts = array() ) {
		if ( ! is_array( $atts ) ) {
			$atts = shortcode_parse_atts( $atts );
		}

		if ( ! is_array( $atts ) || empty( $atts ) ) {
			return '';
		}

		$image_id = null;
		if ( array_key_exists( 'image_id', $atts ) ) {
			$image_id = $atts['image_id'];
		} elseif ( array_key_exists( 'id', $atts ) ) {
			$image_id = $atts['id'];
		}

		if ( empty( $image_id ) ) {
			return '';
		}

		$size = 'large';
		if ( array_key_exists( 'size', $atts ) ) {
			$size = $atts['size'];
		}

		$classes = array();
		if ( array_key_exists( 'align', $atts ) ) {
			array_push( $classes, 'align' . $atts['align'] );
		}

		if ( array_key_exists( 'class', $atts ) ) {
			$classes = array_merge( $classes, explode( ' ', $atts['class'] ) );
		}

		if ( array_key_exists( 'xclass', $atts ) ) {
			$classes = array_merge( $classes, explode( ' ', $atts['xclass'] ) );
		}

		$image = wp_get_attachment_image( $image_id, $size, false, array( 'class' => implode( ' ', $classes ) ) );

		if ( array_key_exists( 'url', $atts ) ) {
			$url = $atts['url'];

			if ( array_key_exists( 'button', $atts ) ) {
				$text = $atts['button'];
			} else {
				$path    = parse_url( $atts['url'], PHP_URL_PATH );
				$post_id = get_page_by_path( $path );
				$text    = get_the_title( $post_id );
			}

			$title = $text;
			if ( array_key_exists( 'title', $atts ) ) {
				$title = $atts['title'];
			}

			$button = sprintf( '<a href="%s" title="%s" class="pure-button pure-button-primary">%s</a>', $url, $title, $text );

			return sprintf( '<div class="c-image-block">%s%s</div>', $image, $button );
		} else if ( array_key_exists( 'description', $atts ) ) {
			$style = '';
			if ( array_key_exists( 'width', $atts ) ) {
				$width = $atts['width'];
				if ( is_numeric( $width ) ) {
					$width .= 'px';
				}

				$style = sprintf( ' pull-left" style="width: %s', $width );
			}

			return sprintf( '<div class="c-image-block%s">%s<p>%s</p></div>', $style, $image, $atts['description'] );
		}

		return $image;
	}

	/**
	 * Display a whitespace block.
	 *
	 * @param array|string $atts List of attributes added to the shortcode.
	 *
	 * @return string
	 */
	public static function whitespace( $atts = array() ) {
		if ( ! is_array( $atts ) ) {
			$atts = shortcode_parse_atts( $atts );
		}

		$style = '';
		if ( ! empty( $atts ) && is_array( $atts ) && array_key_exists( 'width', $atts ) ) {
			$width = $atts['width'];
			if ( is_numeric( $width ) ) {
				$width .= 'px';
			}

			$style = sprintf( ' pull-left" style="width: %s', $width );
		}

		return sprintf( '<div class="c-whitespace%s"></div>', $style );
	}

	/**
	 * Display a Font Awesome icon.
	 *
	 * @param array|string $atts List of attributes added to the shortcode.
	 *
	 * @return string
	 */
	public static function FontAwesomeIcon( $atts = array() ) {
		if ( ! is_array( $atts ) ) {
			$atts = shortcode_parse_atts( $atts );
		}

		if ( empty( $atts ) || ! is_array( $atts ) || ! array_key_exists( 'type', $atts ) ) {
			return '';
		}

		return sprintf( '<i class="fa fa-%s%s" aria-hidden="true"></i>', $atts['type'], array_key_exists( 'xclass', $atts ) ? ' ' . $atts['xclass'] : '' );
	}

	/**
	 * Display a read more button.
	 *
	 * @param array|string $atts    List of attributes added to the shortcode.
	 * @param string       $content Content between opening an closing tag.
	 *
	 * @return string
	 */
	public static function readMoreButton( $atts = array(), $content = '' ) {
		if ( ! is_array( $atts ) ) {
			$atts = shortcode_parse_atts( $atts );
		}

		$defaults = array(
			'href'  => get_the_permalink(),
			'title' => get_seo_title(),
			'text'  => _x( 'Lees meer', 'read-more shortcode', 'base-theme' ) . ' &raquo;'
		);
		$defaults = apply_filters( 'default_read_more_button_args', $defaults );
		if ( ! empty( $content ) ) {
			$defaults['text'] = $content;
		}

		$args = wp_parse_args( $atts, $defaults );

		return sprintf( '<a href="%s" class="pure-button pure-button-link read-more" title="%s">%s</a>', $args['href'], $args['title'], $args['text'] );
	}

}