<?php

namespace BaseTheme\Basics;

class Notification {

	public static function send( $subject, $message, $mail_addresses = array() ) {
		foreach ( $mail_addresses as $mail_address ) {
			wp_mail( $mail_address, $subject, $message );
		}

		$data = http_build_query( array(
			'username'    => get_bloginfo( 'name' ),
			'text'        => '',
			'attachments' => array(
				array(
					'title' => $subject,
					'text'  => $message,
				)
			)
		) );

		$ch = curl_init( 'https://notify.yndenz.com/hooks/' . YNDENZ_NOTIFICATION_TOKEN );
		curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'POST' );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		$result = curl_exec( $ch );
		curl_close( $ch );

		if ( empty( $result ) ) {
			return false;
		}

		$result = json_decode( $result, true );

		if ( array_key_exists( 'success', $result ) && $result['success'] ) {
			return true;
		}

		return $result;
	}

}