<?php get_header(); ?>

<?php get_template_part( 'partials/banner' ); ?>

<div class="fullwidth fwContent">
    <div class="container cContent" data-sidebar="1">

		<?php get_template_part( 'partials/breadcrumb-cta-bar', null, array( 'data' => array( 'container' => false ) ) ); ?>

        <section class="content js-content" role="main">
			<?php
			global $post;
			$content = $post->post_content;
			if ( strpos( $post->post_content, '<h1>' ) === false ) :
				$content = '<h1>' . get_the_title() . '</h1>' . $content;
			endif;
			$content_filtered = apply_filters( 'the_content', $content );

			ob_start();
			?>
            <header class="content__header">
                <h1$1>$2</h1>
                <time>
					<?php the_time( get_option( 'date_format' ) ); ?>
                </time>
            </header>
            <div>
				<?php
				$content_restructured = preg_replace( '/<h1(.*)>(.*)<\/h1>/is', ob_get_clean(), $content_filtered );
				echo $content_restructured;
				?>
            </div>
        </section>

        <aside class="sidebar">
			<?php get_sidebar(); ?>
        </aside>
    </div>
</div>

<?php get_footer(); ?>
