## Stylesheet in words:

In _ourmaincss.scss is where all the files are combined into one file. Previously this was our _pure-extended.scss, but
we removed the pure dependency, because it was too tedious. (renamed afterwards)

#### table of contents:

1. Introduction blocks
2. Introduction components
3. Introduction main
4. Introduction settings
5. Advanced: Handy mixins/classes + usage

---

### 1. Introduction basic block

In the blocks folder are the scss files for styling per block, blocks are mostly project based, projecst can easily
share blocks however. A well-formatted block looks like this:

```html

<div class="fullwidth fwXxx">
    <div class="container cXxx">

    </div>
</div>
```

The scss file would look like this:

```scss
.fwXxx {
  // is most of the time empty, if you 
  // have to make alot of overrides here
  // you need to re-think your component

  .breadcrumb {
    // only overriding a specific component 
    // for this block
    padding: 20px 0;
  }
}

.cXxx {
  // in this block we can make changes regarding 
  // the container, let's say we want the width 
  // of this block to be different than the 
  // original .container
}
```

The default block consists of a fullwidth class and a container class, where the fwXxx is used to if you want to
override a specific component/element for that block only (but not on component level, but on block level). Same goes
for container element. Because we use the bem structure, we can make easy overrides by adding one class on highest
level (css specificity)

---

### 2. Introduction components

Components are mostly project bases, projects can share components. A well formatted component looks like this:

```html

<div class="breadcrumb">
    <a class="breadcrumb__crumb">Home</a>
    <span class="breadcrumb__divider">/</span>
    ...
</div>
```

The bem structure for the scss would look as the following:

```scss
.breadcrumb {
  $this: &;

  &__crumb {

  }

  &__divider {

  }
}
```

Explanation: the

```scss
&__xxx
```

means: It is an element within the component and can only be used in combination with the main component.

Also notice how we cache the selector with :

```scss 
$this: &; 
```

Caching the selector comes in handy if you want to make an element override (for a modifier) without having to repeat
yourself, if the parent selector changes, you only have to change it in one place.

#### Modifier + Cache Example:

```html

<div class="breadcrumb breadcrumb--light">
    <a class="breadcrumb__crumb">Home</a>
    <span class="breadcrumb__divider">/</span>
    ...
</div>
```

Scss without caching (grows ugly real quick):

```scss
.breadcrumb {
  &--light {
    .breadcrumb__crumb {
      color: black;
    }
  }
}
```

Scss with caching:

```scss
.breadcrumb {
  $this: &;

  &--light {
    #{$this}__crumb {
      color: black;
    }
  }
}
```

---

### 3. Introduction main

In the main folder go all the files that are ALWAYS present. Every website has a: Footer, header, navigation, content,
editor styles

---

### 4. Introduction settings

Here goes the variable which are site specific, but also setting some defaults/registering some utility classes like:
.container/.fullwidth etc, also the mixins & scss functions are listed here.

---

### 5. Advanced: Handy mixins + usage

#### give-variants

An advanced mixin to create certain variants of a component: See gist for examples + code
usage: https://gist.github.com/stmpr/8847c8af4de955c00a85aaa6639d722b

---

#### give-circle

A simple mixin to make an element a circle with centered child element, accepts 1 parameter which is the diameter in
pixels

Use it like so:

```scss
.social {
  @include give-circle(20px);
}
```

---

#### [data-equalcol]

It's a utility class actually. Use it like so: Add [data-equalcol='3'] or [data-equalcol='4'] to an html element. Went
for a data-attribute instead of a class, because this data attribute says something about the structured data of posts
in this instance

```html

<div class="posts" data-equalcol="3">
    <div class="post"></div>
    <div class="post"></div>
    ...
</div>
```

---

#### no-last

A simple mixin to style a list of items where the last child should not have the style applied.

Use it like so:

```scss
ul {
  li {
    @include no-last('margin-bottom', 10px);
  }
}
```

---