<?php

get_header();

get_template_part( 'partials/banner' );
get_template_part( 'partials/breadcrumb-cta-bar' );
?>

    <div class="fullwidth fwContent">
        <div class="container cContent">
            <section role="main" class="content js-content">
                <header class="content__header">
                    <h1>
						<?php
						if ( ! empty( get_search_query() ) ) :
							printf( _x( 'Zoekresultaten voor "%s"', 'Zoekresultaten', 'base-theme' ), get_search_query() );
						else :
							_ex( 'Zoeken', 'Zoekresultaten', 'base-theme' );
						endif;
						?>
                    </h1>
                </header>

                <div class="filters">
					<?php dynamic_sidebar( 'search-sidebar' ); ?>
                </div>

				<?php
				if ( have_posts() ) :
					get_template_part( 'partials/loop', 'posts' );

					if ( function_exists( 'wp_pagenavi' ) ) :
						printf( '<div class="pagination">%s</div>', wp_pagenavi( array(
							'echo'          => false,
							'wrapper_class' => 'pagination'
						) ) );
					endif;
                elseif ( ! empty( get_search_query() ) ) :
	                echo apply_filters( 'the_content', get_field( 'geen_resultaten', 'options' ) );
				endif;
				?>
            </section>
        </div>
    </div>

<?php get_footer(); ?>