<?php

get_header();

if ( class_exists( '\\yndenz\\Modules\\Banner\\Banner' ) ) :
	$banner = new \yndenz\Modules\Banner\Banner();
	$banner->initialize( get_archive_title() );
	$banner->display();
endif;

get_template_part( 'partials/breadcrumb-cta-bar' );
?>

    <div class="fullwidth fwContent">
        <div class="container cContent">
            <section class="content js-content" role="main">
                <header class="content__header<?php echo isset( $banner ) && $banner->isTitleIncluded() ? ' sr-only' : ''; ?>">
                    <h1><?php echo $title; ?></h1>
                </header>

				<?php echo category_description(); ?>

				<?php if ( is_date() || is_post_type_archive( [ 'post' ] ) || is_category() || is_tag() ) : ?>
                    <div class="filters filters--archive">
						<?php dynamic_sidebar( 'archive-news-sidebar' ); ?>
                    </div>
				<?php endif; ?>

				<?php get_template_part( 'partials/loop', 'posts' ); ?>

				<?php
				if ( function_exists( 'wp_pagenavi' ) ) :
					printf( '<div class="pagination">%s</div>', wp_pagenavi( array(
						'echo'          => false,
						'wrapper_class' => 'pagination'
					) ) );
				endif;
				?>
            </section>
        </div>
    </div>

<?php get_footer(); ?>