var gulp = require('gulp');
var sass = require('gulp-sass')(require('sass'));
var sourcemaps = require('gulp-sourcemaps');
var babel = require('gulp-babel');
var uglify = require('gulp-uglify');
var rename = require('gulp-rename');
var cleanCSS = require('gulp-clean-css');
var autoprefixer = require('gulp-autoprefixer');
var livereload = require('gulp-livereload');

var paths = {
    styles: {
        watch: [
            'style/**/*.scss'
        ],
        src: [
            'style/**/*.scss'
        ],
        dest: 'assets/style/'
    },
    scripts: {
        src: [
            'js/**/*.js'
        ],
        dest: 'assets/scripts/'
    },
    images: {
        src: [
            'images/**/*'
        ],
        dest: 'assets/images/'
    },
    fonts: {
        src: [
            'fonts/**/*.eot',
            'fonts/**/*.ttf',
            'fonts/**/*.woff',
            'fonts/**/*.woff2',
            'fonts/**/*.svg'
        ],
        dest: 'assets/fonts/'
    }
};

function styles() {
    return gulp.src(paths.styles.src)
        .pipe(sourcemaps.init())
        .pipe(sass({outputStyle: 'compressed'}).on('error', sass.logError))
        .pipe(sourcemaps.write())
        .pipe(autoprefixer())
        .pipe(cleanCSS())
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.styles.dest))
        .pipe(livereload());
}

function scripts() {
    return gulp.src(paths.scripts.src, {sourcemaps: true})
        .pipe(babel())
        .pipe(uglify())
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.scripts.dest));
}

function fonts() {
    return gulp.src(paths.fonts.src)
        .pipe(gulp.dest(paths.fonts.dest));
}

function images() {
    return gulp.src(paths.images.src)
        .pipe(gulp.dest(paths.images.dest));
}

function watch() {
    livereload.listen();
    gulp.watch(paths.scripts.src, scripts);
    gulp.watch(paths.styles.watch, styles);
    gulp.watch(paths.fonts.src, fonts);
    gulp.watch(paths.images.src, images);
}

gulp.task('styles', styles);
gulp.task('scripts', scripts);
gulp.task('fonts', fonts);
gulp.task('images', images);
gulp.task('watch', watch);

gulp.task('default', gulp.parallel('styles', 'scripts', 'fonts', 'images'));