<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta http-equiv="content-type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <base href="<?php echo esc_url( home_url() ); ?>">
    <title><?php wp_title( '|' ); ?></title>
	<?php
	$dns_prefetch = apply_filters( 'base_theme_dns_prefetch', array( 'https://www.googletagmanager.com' ) );
	foreach ( $dns_prefetch as $url ) :
		printf( '<link href="%s" rel="dns-prefetch">', $url );
	endforeach;

	wp_head();
	?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.5.1/gsap.min.js"></script>
    <script src="https://unpkg.com/@barba/core"></script>
</head>

<?php
$scroll_on_hash = apply_filters( 'scroll_on_hash', true );
if ( $scroll_on_hash ) :
	$scroll_on_hash = ' data-scroll-on-hash="true"';
endif;

$scroll_offset = apply_filters( 'scroll_offset', false );
if ( $scroll_offset ) :
	$scroll_offset = ' data-scroll-offset="' . $scroll_offset . '"';
endif;
?>
<body <?php body_class();
echo $scroll_on_hash;
echo $scroll_offset; ?>>

<header class="fullwidth fwNavbar">
	<?php
	if ( class_exists( '\\yndenz\\Modules\\Navigation\\Navbar' ) ) :
		$navbar = new \yndenz\Modules\Navigation\Navbar();
		$navbar->display();
	else :
		printf( '<nav>%s</nav>', wp_nav_menu( array( 'theme_location' => 'navbar', 'echo' => false ) ) );
	endif;
	?>
</header>