<?php
global $post;
$seo_title = $post->post_title;
if ( empty( $seo_title ) ) :
	$seo_title = get_the_title();
endif;

?>
<article id="card-<?php the_ID(); ?>" <?php post_class( 'card' ); ?>>
    <header>
        <a href="<?php the_permalink(); ?>" class="card__image" title="<?php echo $seo_title; ?>">
            <span class="card__imageholder">
                <?php
                if ( class_exists( '\\yndenz\\Modules\\Banner\\Banner' ) ) :
	                $banner = new \yndenz\Modules\Banner\Banner();
	                $banner->initialize( null, 'medium' );
	                $banner->displayImage();
                elseif ( has_post_thumbnail() ) :
	                the_post_thumbnail();
                endif;
                ?>
            </span>
        </a>
		<?php
		if ( is_archive() && is_main_query() ) :
			printf( '<h2 class="card__title"><a href="%s" title="%s">%s</a></h2>', get_permalink(), $seo_title, get_the_title() );
		else :
			printf( '<h3 class="card__title"><a href="%s" title="%s">%s</a></h3>', get_permalink(), $seo_title, get_the_title() );
		endif;
		?>
        <p class="card__date date">
            <time datetime="<?php the_date( 'c' ); ?>">
                <small><?php the_time( get_option( 'date_format' ) ); ?></small>
            </time>
        </p>
    </header>
    <p class="card__content">
		<?php the_excerpt(); ?>
    </p>
    <p class="card__more">
		<?php echo do_shortcode( '[read_more_button]' ); ?>
    </p>
</article>