<?php

load_theme_textdomain( 'base-theme', get_stylesheet_directory() . '/languages' );

\yndenz\Modules\JSON_LD\JSON_LD::init();

\BaseTheme\Basics\Reset::init();
\BaseTheme\Basics\ThemeSupport::init();
\BaseTheme\Basics\ThemeOptions::init();
\BaseTheme\Basics\Shortcodes::init();
\BaseTheme\Basics\Menu::init();
\BaseTheme\Basics\Sidebars::init();
\BaseTheme\Basics\Scripts::init();
\BaseTheme\Basics\Pagination::init();

include 'breadcrumb.php';

if ( ! function_exists( 'print_rr' ) ) {
	/**
	 * This custom version of print_r saves a lot of typing
	 *
	 * @param mixed $var the variable to display
	 */
	function print_rr( $var ) {
		echo '<pre>';
		print_r( $var );
		echo '</pre>';
	}
}

if ( ! function_exists( 'dd' ) ) {
	/**
	 * Dump and die.
	 * Use for development only!
	 *
	 * @param mixed $var
	 *
	 * @uses print_rr()
	 *
	 */
	function dd( $var ) {
		print_rr( $var );
		die();
	}
}

if ( ! function_exists( 'is_yndenz' ) ) {
	/**
	 * Check if the visitor is an yndenz employee.
	 *
	 * @param string $IP
	 *
	 * @return bool
	 */
	function is_yndenz( $IP = '83.87.228.21' ) {
		return $_SERVER['REMOTE_ADDR'] === $IP;
	}
}

if ( ! function_exists( 'notify_yndenz' ) ) {
	/**
	 * Notify yndenz through Rocket Chat.
	 *
	 * @param string $token The webhook integration token for Rocket Chat
	 * @param string $subject Subject of the message you want to send
	 * @param string $message Message you want to send
	 * @param array $mail_addresses Optional e-mail addresses to send a notification too
	 *
	 * @return bool true if successful, false if request failed, response body if unexpected response
	 */
	function notify_yndenz( $token, $subject, $message, $mail_addresses = array() ) {
		if ( ! defined( 'YNDENZ_NOTIFICATION_TOKEN' ) ) {
			define( 'YNDENZ_NOTIFICATION_TOKEN', $token );
		}

		return \BaseTheme\Basics\Notification::send( $subject, $message, $mail_addresses );
	}
}

if ( ! function_exists( 'structured_content' ) ) {
	/**
	 * Display the page content using structured data.
	 *
	 * @param bool $echo If false, the page content will be returned.
	 *
	 * @return string|null
	 */
	function structured_content( $echo = true ) {
		$output = sprintf( '<header class="content__header"><h1>%s</h1></header>%s', get_the_title(), get_the_content() );

		if ( $echo ) {
			echo $output;
		} else {
			return $output;
		}

		return null;
	}
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 *
 * @return array with updated values
 */
add_filter( 'autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1 );
function custom_autoptimize_css_location( $location ) {
	$location[0] = "</head>"; // tag
	$location[1] = "before"; // injection

	return $location;
}

function get_company_logo( $size = 'medium', $title = null ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogo( $size, $title );
}

function get_company_logo_id() {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoID();
}

function get_company_logo_url( $size = 'medium' ) {
	return \BaseTheme\Basics\ThemeSupport::getCompanyLogoURL( $size );
}

function get_archive_title() {
	return \BaseTheme\Basics\ThemeSupport::getArchiveTitle();
}

add_filter( 'href_phone_number', function ( $phone_number ) {
	return preg_replace( '/[^\d\+]+/i', '', preg_replace( '/\(.+\)/i', '', $phone_number ) );
} );

/*
 *
 function favicon4admin() {
	echo '<link rel="Shortcut Icon" type="image/x-icon" href="' . get_stylesheet_directory_uri() . '/assets/images/favicon/favicon-backend.ico" />';
	echo '<style>.acf-field-banner-content{display: none;}</style>';
}

add_action( 'admin_head', 'favicon4admin' );
 *
 */


//HTML5 SUPPORT
add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script' ) );

//DEFAULT LAZY LOADING UITZETTEN, GEBRUIKEN WE EEN PLUGIN VOOR
add_filter( 'wp_lazy_loading_enabled', '__return_false' );

// Toevoegen van template kolom, en filter op template kolom
// https://nl.wordpress.org/plugins/filter-page-by-template/
class FilterPagesByTemplate {

	public function __construct() {
		add_action( 'restrict_manage_posts', array( $this, 'filter_dropdown' ) );
		add_filter( 'request', array( $this, 'filter_post_list' ) );

		add_filter( 'manage_pages_columns', array( $this, 'post_list_columns_head' ) );
		add_action( 'manage_pages_custom_column', array( $this, 'post_list_columns_content' ), 10, 2 );

	}

	public function filter_dropdown() {
		if ( $GLOBALS['pagenow'] === 'upload.php' ) {
			return;
		}

		$template      = isset( $_GET['page_template_filter'] ) ? $_GET['page_template_filter'] : "all";
		$default_title = apply_filters( 'default_page_template_title', __( 'Default Template' ), 'meta-box' );
		?>
		<select name="page_template_filter" id="page_template_filter">
			<option value="all">All Page Templates</option>
			<option value="all_missing" style="color:red" <?php echo ( $template == 'all_missing' ) ? ' selected="selected" ' : ""; ?>>All Missing Page Templates</option>
			<option value="default" <?php echo ( $template == 'default' ) ? ' selected="selected" ' : ""; ?>><?php echo esc_html( $default_title ); ?></option>
			<?php page_template_dropdown( $template ); ?>
		</select>
		<?php
	}//end func

	public function filter_post_list( $vars ) {

		if ( ! isset( $_GET['page_template_filter'] ) ) {
			return $vars;
		}
		$template = trim( $_GET['page_template_filter'] );

		$data        = get_option( "filter_page_by_template_data", array() );
		$filter_used = isset( $data['filter_used'] ) ? intval( $data['filter_used'] ) : 0;
		$filter_used ++;
		$data['filter_used'] = $filter_used;
		update_option( "filter_page_by_template_data", $data );

		if ( $template == "" || $template == 'all' ) {
			return $vars;
		}

		if ( $template == 'all_missing' ) {
			$templates        = wp_get_theme()->get_page_templates( null, 'page' );
			$template_files   = array_keys( $templates );
			$template_files[] = 'default';
			$vars             = array_merge(
				$vars,
				array(
					'meta_query' => array(
						array(
							'key'     => '_wp_page_template',
							'value'   => $template_files,
							'compare' => 'NOT IN',
						)
					),
				)
			);
		} else {
			$vars = array_merge(
				$vars,
				array(
					'meta_query' => array(
						array(
							'key'     => '_wp_page_template',
							'value'   => $template,
							'compare' => '=',
						),
					),
				)
			);
		}

		return $vars;

	}//end func

	# Add new column to post list
	public function post_list_columns_head( $columns ) {
		$columns['template'] = 'Template';

		return $columns;
	}

	#post list column content
	public function post_list_columns_content( $column_name, $post_id ) {
		$post_type = 'page';

		if ( $column_name == 'template' ) {
			$template = get_post_meta( $post_id, "_wp_page_template", true );
			if ( $template ) {
				if ( $template == 'default' ) {
					$template_name = apply_filters( 'default_page_template_title', __( 'Default Template' ), 'meta-box' );
					echo '<span title="Template file : page.php">' . $template_name . '</span>';
				} else {
					$templates = wp_get_theme()->get_page_templates( null, $post_type );

					if ( isset( $templates[ $template ] ) ) {
						echo '<span title="Template file : ' . $template . '">' . $templates[ $template ] . '</span>';
					} else {

						echo '<span style="color:red" title="This template file does not exist">' . $template . '</span>';
					}
				}
			}
		}
	}
}//end class

if ( is_admin() ) {
	new FilterPagesByTemplate();
}

//Remove JQuery migrate
function remove_jquery_migrate( $scripts ) {
	if ( ! is_admin() && isset( $scripts->registered['jquery'] ) ) {
		$script = $scripts->registered['jquery'];
		if ( $script->deps ) {
			$script->deps = array_diff( $script->deps, array( 'jquery-migrate' ) );
		}
	}
}
add_action( 'wp_default_scripts', 'remove_jquery_migrate' );

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );

// Disables the block editor from managing widgets.
add_filter( 'use_widgets_block_editor', '__return_false' );


function giveicon( $name, $type = 'svg', $alt = '' ) {
	if ( $type === 'png' ):
		$html = '';
		$html .= '<img src="' . get_stylesheet_directory_uri() . '/images/icons/' . $name . '.png" alt="' . $alt . '"/>';
		echo $html;
	else:
		return include( get_stylesheet_directory() . '/images/icons/' . $name . '.svg' );
	endif;
}

function getRefererPage( $form_tag ) {
	if ( isset( $_SERVER['HTTP_REFERER'] ) && $form_tag['name'] == 'referer-page' ) {
		$form_tag['values'][] = htmlspecialchars( ( isset( $_SERVER['HTTPS'] ) ? "https" : "http" ) . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] );
	}

	return $form_tag;
}


if ( ! is_admin() ) {
	add_filter( 'wpcf7_form_tag', 'getRefererPage' );
}

//If above the fold stylesheet is present, grab the css file contents and place it inline so it will render first
function inline_abovethefold_css() {
	$css_file = get_stylesheet_directory() . '/assets/style/above-the-fold.min.css';

	if ( file_exists( $css_file ) ):
		$critical_css = file_get_contents( get_stylesheet_directory() . '/assets/style/above-the-fold.min.css' );
		echo '<style>' . $critical_css . '</style>';
	endif;
}

add_action( 'wp_head', 'inline_abovethefold_css' );

//Remove Gutenberg Block Library CSS from loading on the frontend
function smartwp_remove_wp_block_library_css() {
	wp_dequeue_style( 'wp-block-library' );
	wp_dequeue_style( 'wp-block-library-theme' );
	wp_dequeue_style( 'wc-block-style' ); // Remove WooCommerce block CSS
}

add_action( 'wp_enqueue_scripts', 'smartwp_remove_wp_block_library_css', 200 );

function get_seo_title () {
    return get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
}

function the_seo_title () {
    echo get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
}

function restructuredContent( $include_date = false, $after_title = '' ) {
    global $post;

    $content = $post->post_content;

    // Add the title if it's not already in the content
    if ( preg_match( '/<h1(.*)>(.*)<\/h1>/i', $post->post_content ) <= 0 ) :
        $content = '<h1>' . get_the_title() . '</h1>' . $content;
    endif;

    $content_filtered = apply_filters( 'the_content', $content );

    if ( version_compare( WPSEO_VERSION, '11.0', '<' ) ) {
        $title = '<h1 itemprop="name"$1>$2</h1>';
    } else {
        $title = '<h1$1>$2</h1>';
    }

    $date = '';
    if ( $include_date ) {
        $datetime = get_the_time( 'Y-m-d' );
        if ( version_compare( WPSEO_VERSION, '11.0', '<' ) ) {
            $date = sprintf( '<time datetime="%s" pubdate itemprop="datePublished" content="%s">%s</time>', $datetime, $datetime, get_the_date() );
            $date .= sprintf( '<meta itemprop="dateModified" content="%s"/>', get_the_modified_time( 'Y-m-d' ) );
        } else {
            $date = sprintf( '<time datetime="%s">%s</time>', $datetime, get_the_date() );
        }
    }

    $page_header = sprintf( '<header class="page-header">%s</header>', $title . $date . $after_title );

    $content_restructured = preg_replace( '/<h1(.*)>(.*)<\/h1>/i', $page_header, $content_filtered );
    if ( version_compare( WPSEO_VERSION, '11.0', '<' ) ) {
        $content_restructured = preg_replace( '/<p([^>]*)>/i', '<p itemprop="description"$1>', $content_restructured, 1 );
    }

    return $content_restructured;
}