<?php
/**
 * Plugin initialization file
 *
 * @package Yndenz Dynamic Google Maps Loading
 * @author Erwin Wensveen <e.wensveen@yndenz.com>
 * @since 1.0.0
 *
 * @wordpress-plugin
 * Plugin Name: Yndenz Dynamic Google Maps Loading
 * Plugin URI:  https://wordpress.org/plugins/bootstrap-for-contact-form-7/
 * Description: Load Google Maps assets not before needed
 * Version:     1.1.0
 * Author:      Erwin Wensveen
 */

function dgml_init() {
	add_action( 'wp_enqueue_scripts', 'dgml_assets', 999 );

}
add_action( 'init', 'dgml_init', 50 );


function dgml_assets() {
	wp_enqueue_script( 'dynamic-googlemaps-script', plugins_url( '/assets/js/dynamic-gmaps.min.js', __FILE__ ), array(), false, true );
	wp_enqueue_style( 'dynamic-googlemaps-styles', plugins_url( '/assets/style/dynamic-gmaps.min.css', __FILE__ ), array(), false, 'all' );
}