let mapLoaded = false;

document.addEventListener("DOMContentLoaded", function () {

    //TRIGGER ON INTERACTION: CLICK
    if(document.querySelector('.gmap__holder')){
        document.querySelector('.gmap__holder').addEventListener('click', initScript);
    }

    /**
     *
     */
    function initScript() {

        if(!mapLoaded) {

            //https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d13803.362529507103!2d5.622581449320813!3d52.295806863491194!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47c6346c9eb51f2d%3A0xc5b2381d2d536b08!2sPutterweg+45%2C+3851+GB+Ermelo!5e0!3m2!1snl!2snl!4v1516193175361
            let mapHolder = document.querySelector('.gmap__holder');

            //ADD CLASS TO PARENT TO FADE OUT THE THUMBNAIL IMAGE
            mapHolder.classList.add('__loaded');

            var googlemapKey = mapHolder.getAttribute("data-mapkey");
            var iframeUrl = mapHolder.getAttribute("data-iframe_url");

            //INITIALIZE THE SCRIPT
            var script_url = "";

            //Do we have a key?
            if(googlemapKey !== ""){
                script_url = 'https://maps.googleapis.com/maps/api/js?key=' + googlemapKey + '&map_ids=a596eff6693adcca&callback=initMap';
                loadScript(script_url,function(){
                    initMap();
                })
            }
            //or do we have an embed url?
            else if(iframeUrl !== ""){
                script_url = iframeUrl;
                loadIframe(mapHolder, script_url, function(){});
            }

            mapLoaded = true;
        }
    }

    /**
     *
     * @param parent
     * @param url
     * @param callback
     */
    function loadIframe(parent, url, callback) {
        var iframe = document.createElement("iframe")
        iframe.setAttribute("src", url);
        //ifrm.style.width = "640px";
        //ifrm.style.height = "480px";
        parent.appendChild(iframe);

        iframe.onload = function () {
            callback();
        };
    }

    /**
     *
     * @param url
     * @param callback
     */
    function loadScript( url, callback ) {
        var script = document.createElement( "script" )
        script.type = "text/javascript";
        if(script.readyState) {  // only required for IE <9
            script.onreadystatechange = function() {
                if ( script.readyState === "loaded" || script.readyState === "complete" ) {
                    script.onreadystatechange = null;
                    callback();
                }
            };
        } else {  //Others
            script.onload = function() {
                callback();
            };
        }

        script.src = url;
        document.getElementsByTagName( "head" )[0].appendChild( script );
    }


    /**
     *
     */
    function initMap() {

        let mapHolder = document.querySelector('.gmap__holder');
        const iconBase = mapHolder.getAttribute("iconbase");
        let map;
        let features = [];
        let locations = JSON.parse(mapHolder.getAttribute("data-locations"));

        var stylesArray = [
            {
                "featureType": "administrative",
                "elementType": "all",
                "stylers": [
                    {
                        "weight": "1.26"
                    },
                    {
                        "saturation": "-100"
                    },
                    {
                        "lightness": "-4"
                    }
                ]
            },
            {
                "featureType": "administrative.neighborhood",
                "elementType": "all",
                "stylers": [
                    {
                        "weight": "2.42"
                    },
                    {
                        "hue": "#005aff"
                    },
                    {
                        "lightness": "-3"
                    },
                    {
                        "saturation": "-76"
                    },
                    {
                        "gamma": "0.87"
                    }
                ]
            },
            {
                "featureType": "administrative.neighborhood",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "saturation": "-11"
                    },
                    {
                        "lightness": "6"
                    }
                ]
            },
            {
                "featureType": "landscape.man_made",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#f7f1df"
                    },
                    {
                        "saturation": "-22"
                    },
                    {
                        "lightness": "22"
                    },
                    {
                        "gamma": "1.00"
                    }
                ]
            },
            {
                "featureType": "landscape.natural",
                "elementType": "all",
                "stylers": [
                    {
                        "saturation": "32"
                    },
                    {
                        "lightness": "10"
                    }
                ]
            },
            {
                "featureType": "poi",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "on"
                    }
                ]
            },
            {
                "featureType": "poi.getAttributeaction",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "lightness": "12"
                    },
                    {
                        "saturation": "-27"
                    },
                    {
                        "gamma": "1.00"
                    },
                    {
                        "weight": "0.87"
                    }
                ]
            },
            {
                "featureType": "poi.business",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.business",
                "elementType": "geometry",
                "stylers": [
                    {
                        "visibility": "on"
                    }
                ]
            },
            {
                "featureType": "poi.business",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "saturation": "18"
                    },
                    {
                        "hue": "#ffc100"
                    },
                    {
                        "lightness": "15"
                    }
                ]
            },
            {
                "featureType": "poi.park",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#bde6ab"
                    }
                ]
            },
            {
                "featureType": "poi.sports_complex",
                "elementType": "geometry",
                "stylers": [
                    {
                        "hue": "#ff8200"
                    },
                    {
                        "gamma": "1.13"
                    },
                    {
                        "lightness": "-13"
                    },
                    {
                        "saturation": "71"
                    }
                ]
            },
            {
                "featureType": "road",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "lightness": "88"
                    }
                ]
            },
            {
                "featureType": "road",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#ffe15f"
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "color": "#efd151"
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "labels",
                "stylers": [
                    {
                        "saturation": "-63"
                    },
                    {
                        "lightness": "30"
                    },
                    {
                        "gamma": "0.95"
                    },
                    {
                        "weight": "2.76"
                    }
                ]
            },
            {
                "featureType": "road.arterial",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#ffffff"
                    }
                ]
            },
            {
                "featureType": "road.arterial",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "lightness": "30"
                    }
                ]
            },
            {
                "featureType": "road.local",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "black"
                    }
                ]
            },
            {
                "featureType": "road.local",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "saturation": "-77"
                    },
                    {
                        "lightness": "40"
                    }
                ]
            },
            {
                "featureType": "transit.station.airport",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "lightness": "23"
                    },
                    {
                        "saturation": "-38"
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#a2daf2"
                    }
                ]
            }
        ];

        map = new google.maps.Map(document.getElementById("map"), {
            center: {lat: 52.3093587, lng: 6.8478059},
            zoom: 8,
            mapId: 'a596eff6693adcca',
            streetViewControl: false,
            mapTypeControl: false,
            styles: stylesArray
        });

        var bounds = new google.maps.LatLngBounds();

        Array.prototype.forEach.call(locations, function (obj, i) {
            let phoneRaw = obj.phone,
                phoneNoFormat = obj.phone.replaceAll(' ', '');

            const contentString =
                '<div id="content" style="padding: 20px;">' +
                '<span>' + obj.title + '</span>' +
                '<a href="' + obj.website + '" target="_blank">Website</a>' +
                '<a href="tel:' + phoneNoFormat + '"><i class="icon icon-phone"></i>' + phoneRaw + '</a>' +
                '</div>';

            features.push({
                position: new google.maps.LatLng(obj.lat, obj.lng),
                type: "info",
                content: contentString
            });
        });

        var infowindow = new google.maps.InfoWindow; //static infoWindow for all your markers

        // Create markers.
        for (let i = 0; i < features.length; i++) {

            const marker = new google.maps.Marker({
                position: features[i].position,
                icon: iconBase + 'pin.svg',
                map: map,
            });

            bounds.extend(marker.position);

            marker.addListener("click", () => {
                infowindow.setContent(features[i].content);
                infowindow.open(map, marker);

                google.maps.event.addListener(map, "click", function (event) {
                    infowindow.close();
                });
            });
        }

        map.fitBounds(bounds);
    }

});