<?php
/**
 * Plugin initialization file
 *
 * @package Yndenz Dynamic Repaptcha Loading
 * @author Erwin Wensveen <e.wensveen@yndenz.com>
 * @since 1.0.0
 *
 * @wordpress-plugin
 * Plugin Name: Yndenz Dynamic Repaptcha Loading
 * Plugin URI:  https://wordpress.org/plugins/bootstrap-for-contact-form-7/
 * Description: Load recapthca assets not before needed
 * Version:     1.0.1
 * Author:      Erwin Wensveen
 */

function drl_init() {
	add_action( 'get_footer', 'drl_cf7_defer_recaptcha' );
	add_action( 'wp_enqueue_scripts', 'drl_wpcf7_remove_captcha2', 999 );

}
add_action( 'init', 'drl_init', 50 );


function drl_cf7_defer_recaptcha() {
	$sitekeys = array_keys( WPCF7::get_option( 'recaptcha' ) );
	wp_register_script( 'cf7recap', get_template_directory_uri() . '/assets/scripts/recaptcha_v3.min.js', array(), false, true );
	wp_enqueue_script( 'cf7recap');

	wp_localize_script( 'cf7recap', 'sitekey', array( $sitekeys[0] ) );
}


//REMOVE RECAPTCHA FROM PHP! ENQUEUE IT WITH JAVASCRIPT WITH INTERSECTION OBSERVER
function drl_wpcf7_remove_captcha2() {
	wp_dequeue_script( 'google-recaptcha' );
	wp_dequeue_script( 'wpcf7-recaptcha' );
}