/**
 * Used to load and execute javascript file. an be used cross-domain seamlessly.
 * @param file JS file name
 * @param callback Subscribe to get notified when script file is loaded
 **/
function require(file, callback) {
    // create script element

    var script = document.createElement("script");
    script.src = file;

    // monitor script loading
    // IE < 7, does not support onload
    if (callback) {
        script.onreadystatechange = function () {
            if (script.readyState === "loaded" || script.readyState === "complete") {
                // no need to be notified again
                script.onreadystatechange = null;
                // notify user
                callback();
            }
        };

        // other browsers
        script.onload = function () {
            callback();
        };
    }

    // append and execute script
    document.documentElement.firstChild.appendChild(script);
}

var captchaLoaded = false;

document.addEventListener("DOMContentLoaded", function () {

    //Load reCAPTCHA script when body mouse is moved / on mobile touch start
    document.addEventListener("mousemove", initCaptcha, {once: true});
    document.addEventListener("touchstart", initCaptcha, {once: true});


    function initCaptcha() {

        // If we have loaded script once already, exit. Anomaly
        if (captchaLoaded) {
            return;
        }

        console.log('reCAPTCHA script loading.');

        var head = document.getElementsByTagName('head')[0];
        recaptchaScript = document.createElement('script');

        // Dynamically add Recaptcha Script
        recaptchaScript.type = 'text/javascript';
        recaptchaScript.src = 'https://www.google.com/recaptcha/api.js?onload=initCF7Captcha&render=' + sitekey + '&#038;ver=3.0';

        // Add Recaptcha Script to head
        head.appendChild(recaptchaScript);

        //Set flag to only load once
        captchaLoaded = true;
    }
});

//This is the callback function from the script above, so it will ONLY load when the above script is loaded. This will init the WPCF7 Captcha when previous mentioned script is done loading.
function initCF7Captcha() {
    console.log('initCF7loading');

    var head = document.getElementsByTagName('head')[0];

    //THE CAPTCHA SCRIPT
    var cf7recap = document.createElement('script');

    // Dynamically add CF7 grecaptcha script
    cf7recap.type = 'text/javascript';
    cf7recap.text = '!function(t,e){var n={execute:function(e){t.execute(\'' + sitekey + '\',{action:e}).then(function(e){for(var t=document.getElementsByTagName(\'form\'),n=0;n<t.length;n++)for(var c=t[n].getElementsByTagName(\'input\'),a=0;a<c.length;a++){var o=c[a];if(\'g-recaptcha-response\'===o.getAttribute(\'name\')){o.setAttribute(\'value\',e);break}}})},executeOnHomepage:function(){n.execute(e.homepage)},executeOnContactform:function(){n.execute(e.contactform)}};t.ready(n.executeOnHomepage),document.addEventListener(\'change\',n.executeOnContactform,!1),document.addEventListener(\'wpcf7submit\',n.executeOnHomepage,!1)}(grecaptcha,{homepage:\'homepage\',contactform:\'contactform\'});';

    head.appendChild(cf7recap);
}