var gulp = require('gulp');
var sass = require('gulp-sass');
var sourcemaps = require('gulp-sourcemaps');
var babel = require('gulp-babel');
var uglify = require('gulp-uglify');
var rename = require('gulp-rename');
var cleanCSS = require('gulp-clean-css');
var autoprefixer = require('gulp-autoprefixer');
var imagemin = require('gulp-imagemin');
var stripDebug = require('gulp-strip-debug');
var mode = require('gulp-mode')();

var paths = {
    styles: {
        watch: [
            'style/**/*.scss',
        ],
        src: [
            'style/**/*.scss',
        ],
        dest: 'assets/style/'
    },
    move_min_styles: {
        src: [
            'style/**/*.min.css'
        ],
        dest: 'assets/style/'
    },
    scripts: {
        src: [
            'js/**/*.js',
            '!js/**/*.min.js',
        ],
        dest: 'assets/js/'
    },
    move_min_scripts: {
        src: [
            'js/**/*.min.js',
        ],
        dest: 'assets/js/'
    },
    fonts: {
        src: [
            'fonts/**/*.eot',
            'fonts/**/*.ttf',
            'fonts/**/*.woff',
            'fonts/**/*.woff2',
            'fonts/**/*.svg'
        ],
        dest: 'assets/fonts/'
    },
    images: {
        src: [
            'img/**/*'
        ],
        dest: 'assets/img/'
    }
};

function styles() {
    return gulp.src(paths.styles.src)
        .pipe((mode.development(sourcemaps.init())))
        .pipe(sass({outputStyle: 'compressed'}).on('error', sass.logError))
        .pipe((mode.development(sourcemaps.write())))
        .pipe(autoprefixer())
        .pipe(cleanCSS())
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.styles.dest));
}

function move_styles() {
    return gulp.src(paths.move_min_styles.src, {sourcemaps: true})
        .pipe(gulp.dest(paths.move_min_styles.dest));
}

function scripts() {
    return gulp.src(paths.scripts.src, {sourcemaps: true})
        .pipe(babel())
        .pipe(uglify())
        .pipe((mode.production(stripDebug())))
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.scripts.dest));
}

function move_scripts() {
    return gulp.src(paths.move_min_scripts.src, {sourcemaps: true})
        .pipe(gulp.dest(paths.move_min_scripts.dest));
}

function fonts() {
    return gulp.src(paths.fonts.src)
        .pipe(gulp.dest(paths.fonts.dest));
}

function images() {
    return gulp.src(paths.images.src)
        .pipe(imagemin([
            imagemin.gifsicle({interlaced: true}),
            imagemin.mozjpeg({quality: 90, progressive: true}),
            imagemin.optipng({optimizationLevel: 5}),
            imagemin.svgo({
                plugins: [
                    {removeViewBox: true},
                    {cleanupIDs: false}
                ]
            })
        ]))
        .pipe(gulp.dest(paths.images.dest))
}

function watch() {
    gulp.watch(paths.scripts.src, scripts);
    gulp.watch(paths.styles.watch, styles);
    gulp.watch(paths.fonts.src, fonts);
    gulp.watch(paths.images.src, images);
}

gulp.task('styles', styles);
gulp.task('scripts', scripts);
gulp.task('fonts', fonts);
gulp.task('images', images);
gulp.task('watch', watch);
gulp.task('move_scripts', move_scripts);
gulp.task('move_styles', move_styles);

gulp.task('default', gulp.parallel('styles', 'move_styles', 'scripts', 'move_scripts', 'fonts', 'images'));
