<?php

namespace yndenz\Plugins\FeedbackCompany;

class Review {

	/** @var string */
	public $author;

	/** @var int */
	public $date;

	/** @var float */
	public $rating;

	/** @var string */
	public $title;

	/** @var bool|null */
	public $recommend = null;

	/** @var string */
	public $reason = '';

	/** @var string */
	public $text = '';

	/**
	 * Convert an array of data into a review object.
	 *
	 * @param array $data
	 *
	 * @return Review
	 */
	public static function fromData( $data ) {
		$review = new static;
		foreach ( $data as $key => $value ) {
			$review->{$key} = $value;
		}

		return $review;
	}

}
