<?php
/*
Plugin Name: Feedback Company
Plugin URI:  http://www.yndenz.com
Description: Feedbackcompany.com page reader for reviews
Version:     2.0.0
Author:      Gido Manders <g.manders@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: feedback-company
*/

use yndenz\Plugins\FeedbackCompany\Reviews;
use yndenz\Plugins\FeedbackCompany\Scraper;

/**
 * Add a menu item to the settings menu
 */

add_action( 'admin_menu', 'feedback_company_menu' );
function feedback_company_menu() {
	// Add a new submenu under Settings
	add_options_page( __( 'Feedback Company', 'feedback-company' ), __( 'Feedback Company', 'feedback-company' ), 'manage_options', 'feedback-company', 'feedback_company_settings_page' );
}

/**
 * Display the settings page
 */
function feedback_company_settings_page() {
	//must check that the user has the required capability
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
	}

	// See if the user has saved the settings
	if ( isset( $_POST['feedback_company_slug'] ) ) {
		// Save the posted value in the database
		update_option( 'feedback_company_slug', $_POST['feedback_company_slug'] );
		?>
        <div class="updated"><p><strong><?php _e( 'Settings saved.', 'feedback-company' ); ?></strong></p></div>
		<?php
	}
	?>
    <div class="wrap">
        <h2><?php _e( 'Feedback Company Settings', 'feedback-company' ); ?></h2>
        <form name="feedbackCompanySettingsForm" method="post" action="">
            <label>
				<?php _e( "Slug:", 'feedback-company' ); ?>
            </label>
            <input type="text" name="feedback_company_slug"
                   value="<?php echo get_option( 'feedback_company_slug' ); ?>"/>
            <button type="submit" class="button-primary"><?php _e( 'Save', 'feedback-company' ); ?></button>
        </form>
    </div>
	<?php
}

/**
 * Get all feedback-company reviews.
 * Define FEEDBACK_COMPANY_CACHE if you want to cache the reviews (updated hourly)
 *
 * @param bool   $cron
 * @param string $item_reviewed_template
 *
 * @return object|boolean Returns an array containing the reviews, or false if an error occurred.
 */
function feedback_company_get_reviews( $cron = false, $item_reviewed_template = '' ) {
	set_time_limit( 300 );
	$cached_result = null;
	if ( defined( 'FEEDBACK_COMPANY_CACHE' ) && file_exists( FEEDBACK_COMPANY_CACHE ) ) {
		$cached_result = Reviews::fromCache();
	}

	// If the cache file is not defined or the file is updated over an hour ago, fetch the reviews
	if ( $cron || is_null( $cached_result ) ) {
		$base_url = 'https://www.feedbackcompany.com/nl-nl/reviews/' . get_option( 'feedback_company_slug' );
		$base_url = apply_filters( 'feedback_company_base_url', $base_url );

		try {
			$scraper = new Scraper( $base_url, $cached_result );
			$result  = $scraper->fetchReviews();

			if ( $result->found_reviews === 0 ) {
				throw new Exception( 'No reviews' );
			}

			file_put_contents( FEEDBACK_COMPANY_CACHE . '.tmp', json_encode( $result ) );
			rename( FEEDBACK_COMPANY_CACHE . '.tmp', FEEDBACK_COMPANY_CACHE );
		} catch ( Exception $e ) {
			$result = $cached_result;
		}
	} else {
		$result = $cached_result;
	}

	ob_start();
	if ( empty( $item_reviewed_template ) ) {
		$item_reviewed_template = locate_template( 'feedback-company-item-reviewed.php' );
	}
	include $item_reviewed_template;
	$result->item_reviewed = ob_get_clean();

	return $result;
}

/**
 * Get average feedbackcompany.com rating
 */
add_shortcode( 'feedback_company_average', 'feedback_company_average' );
function feedback_company_average() {
	$klantvertellen = feedback_company_get_reviews();

	return $klantvertellen->average;
}

/**
 * Get total feedbackcompany.com reviews
 */
add_shortcode( 'feedback_company_total', 'feedback_company_total' );
function feedback_company_total() {
	$klantvertellen = feedback_company_get_reviews();

	return $klantvertellen->found_reviews;
}
