<?php

namespace yndenz\Plugins\ImportPostThumbnails;

use WP_Query;

class ImportPostThumbnails {

    public static function init() {
        add_action('plugins_loaded', array(static::class, 'loadTextdomain'));
        add_action('admin_menu', array(static::class, 'addMenuItem'));
        add_action('admin_post_import_post_thumbnails', array(static::class, 'process'));
    }

    /**
     * Load text domain for this plugin.
     */
    public static function loadTextdomain() {
        load_plugin_textdomain('import-post-thumbnails', FALSE, basename(dirname(__FILE__)) . '/languages/');
    }

    /**
     * Add an options page to the settings menu in WP Admin.
     */
    public static function addMenuItem() {
        add_options_page(
            __('Import post thumbnails', 'import-post-thumbnails'),
            __('Import post thumbnails', 'import-post-thumbnails'),
            'manage_options',
            'import-post-thumbnails',
            array(static::class, 'optionsPage')
        );
    }

    /**
     * Display the options page.
     */
    public static function optionsPage() {
        if (isset($_SESSION['import_post_thumbnails'])) {
            static::displaySuccessNotice();
        }

        include dirname(__FILE__) . '/templates/options-page.php';
    }

    public static function getPluginURL() {
        return plugin_dir_url(__FILE__);
    }

    public static function process() {
        if (empty($_POST['website'])) {
            return;
        }

        set_time_limit(600);

        $website = $_POST['website'];
        if (strpos($website, 'http') === false) {
            $website = 'https://' . $website;
        }

        $api = trim($website, '/') . '/wp-json/wp/v2/media/';

        $i = 0;
        $wp_query = new WP_Query(array('post_type' => 'post', 'posts_per_page' => -1));
        foreach ($wp_query->posts as $post) {
            $attachment_id = get_post_meta($post->ID, '_thumbnail_id', true);

            if (empty($attachment_id)) {
                continue;
            }

            $media = file_get_contents($api . $attachment_id);

            if ($media === false) {
                continue;
            }

            $media = json_decode($media, true);

            $tmp = download_url($media['guid']['rendered']);
            $file_array = array('tmp_name' => $tmp, 'name' => basename($media['guid']['rendered']));
            $new_attachment_id = media_handle_sideload($file_array, $post->ID, null, array('post_title' => $media['title']['rendered']));

            if (is_wp_error($new_attachment_id)) {
                var_dump('error', $new_attachment_id);
            } else {
                update_post_meta($post->ID, '_thumbnail_id', $new_attachment_id);
            }
            $i++;
        }

        $_SESSION['import_post_thumbnails'] = $i;
        wp_safe_redirect($_SERVER['HTTP_REFERER']);
    }

    public static function displaySuccessNotice() {
        printf('<div class="notice notice-success is-dismissible"><p>%s</p></div>', sprintf(__('Done! Imported %d images', 'import-post-thumbnails'), $_SESSION['import_post_thumbnails']));
        unset($_SESSION['import_post_thumbnails']);
    }

    public static function getVersion() {
        return IMPORT_POST_THUMBNAILS_VERSION;
    }

}