var gulp = require('gulp');
var concat = require('gulp-concat');
var minifyJS = require('gulp-uglify');
var deleteDirs = require('del');
var runSequence = require('run-sequence');


var buildFolder = './assets/cookie-consent';
var jsBuildFiles = [
    './assets/src/cookieconsent.js'
];

gulp.task('cleanup:begin', function () {
    return deleteDirs([buildFolder]);
});

gulp.task('minify:js', function () {
    return gulp.src(jsBuildFiles)            // get files
        .pipe(minifyJS())                      // minify them
        .pipe(concat('cookieconsent.min.js'))  // combine them
        .pipe(gulp.dest(buildFolder));          // save under a new name
});

gulp.task('build', function(callback) {
    return runSequence('cleanup:begin', 'minify:js', callback);
});


gulp.task('watch', function() {
    gulp.watch(jsBuildFiles, ['build']);
});