var gulp = require('gulp');
var sass = require('gulp-sass');
var sourcemaps = require('gulp-sourcemaps');
var cleanCSS = require('gulp-clean-css');
var concat = require('gulp-concat');
var es     = require('event-stream');
var rename = require('gulp-rename');
var minifyJS = require('gulp-uglify');
var deleteDirs = require('del');
var runSequence = require('run-sequence');


var buildFolder = './assets/cookie-consent';
var jsBuildFiles = [
    './assets/src/cookieconsent.js'
];

gulp.task('cleanup:begin', function () {
    return deleteDirs([buildFolder]);
});


gulp.task('styles', function(){

    var cssStream  = gulp.src('./assets/css/cookieconsent.min.base.css');
    var sassStream = gulp.src('./assets/css/icc.scss')
        .pipe(sourcemaps.init())
        .pipe(sass({outputStyle: 'compressed'}).on('error', sass.logError))
        .pipe(sourcemaps.write())
        .pipe(cleanCSS())
        .pipe(rename({
            basename: 'cookieconsent',
            suffix: '.min'
        }))

    return es.merge(cssStream,sassStream)
        .pipe(concat('cookieconsent.min.css'))
        .pipe(gulp.dest(buildFolder));
});

gulp.task('minify:js', function () {
    return gulp.src(jsBuildFiles)            // get files
        .pipe(minifyJS())                      // minify them
        .pipe(concat('cookieconsent.min.js'))  // combine them
        .pipe(gulp.dest(buildFolder));          // save under a new name
});

gulp.task('build', function(callback) {
    return runSequence('cleanup:begin', 'styles', 'minify:js', callback);
});


gulp.task('watch', function() {
    gulp.watch(jsBuildFiles, ['build']);
});