var gulp = require('gulp');
var concat = require('gulp-concat');
var uglify = require('gulp-uglify');
var cleanCSS = require('gulp-clean-css');
var deleteDirs = require('del');
var runSequence = require('run-sequence');
var babel = require('gulp-babel');


var buildFolder = './assets/cookie-consent';
var jsBuildFiles = [
  'vendor/insites/cookieconsent/build/cookieconsent.min.js',
  'src/*.js'
];
var cssBuildFiles = [
  'vendor/insites/cookieconsent/build/cookieconsent.min.css',
  'src/styles/*.css'
];


gulp.task('cleanup:begin', function () {
  return deleteDirs([buildFolder]);
});

gulp.task('minify:js', function () {
  return gulp.src(jsBuildFiles)            // get files
    .pipe(babel())                      // minify them
    .pipe(uglify())                        // uglify them
    .pipe(concat('cookieconsent.min.js'))  // combine them
    .pipe(gulp.dest(buildFolder));         // save under a new name
});

gulp.task('minify:css', function () {
  return gulp.src(cssBuildFiles)            // get files
    .pipe(cleanCSS())                      // minify them
    .pipe(concat('cookieconsent.min.css'))  // combine them
    .pipe(gulp.dest(buildFolder));          // save under a new name
});

gulp.task('build', function(callback) {
  return runSequence('cleanup:begin', 'minify:js', 'minify:css', callback);
});

gulp.task('watch', function() {
  gulp.watch(cssBuildFiles.concat(jsBuildFiles), ['build']);
});

function _minify(opts) {
}
