window.cookieconsent.formValidationFailed = function (message) {
    if ($('.cc-hide-window').length <= 0) {
        $('.cc-window').prepend('<span aria-label="dismiss cookie message" role=button tabindex="0" class="cc-btn cc-hide-window">&times;</span>');
    }
    $('.cc-window').removeClass('cc-invisible').show();
    var link = $('.cc-link');
    var oldMessage = $('.cc-message').html();
    $('.cc-message').html(message);
    $('.cc-message').append(link);
    $('.cc-overlay').show().removeClass('cc-invisible');
    $('.cc-window').addClass('cc-center');
    $('.cc-window .cc-btn, .cc-window a').click(function (e) {
        $('.cc-overlay').addClass('cc-invisible');
        if ($(e.target).hasClass('cc-hide-window')) {
            $('.cc-message').html(oldMessage);
            $('.cc-window').removeClass('cc-center');
            $(this).parent().delay(1000).queue(function (next) {
                $('.cc-overlay').hide();
                next();
            });
        } else {
            $(this).parent().delay(1000).queue(function (next) {
                $('.cc-message').html(oldMessage);
                $(this).removeClass('cc-center');
                $('.cc-overlay').hide();
                next();
            });
        }
    });
};

document.addEventListener("DOMContentLoaded", function () {
    var ccOverlay = document.createElement('div');
    ccOverlay.className = 'cc-overlay cc-invisible';
    ccOverlay.style.display = 'none';
    document.getElementsByTagName('body')[0].insertBefore(ccOverlay, document.getElementsByTagName('body')[0].childNodes[0]);
});

document.addEventListener('wpcf7invalid', function (e) {
    var cookieConsent = [];
    if (e.detail.hasOwnProperty('apiResponse')) {
        cookieConsent = e.detail.apiResponse.invalidFields.filter(function (field) {
            return field.into === '.form-group.pcn';
        });
    }

    if (cookieConsent.length > 0) {
        window.cookieconsent.formValidationFailed(cookieConsent[0].message);
    }
}, false);

document.addEventListener('gform_post_render', function (e, formId) {
    var validationError = $('#gform_' + formId + ' .validation_error');
    if (validationError && validationError.length > 1 && validationError.hasClass('cookie-consent')) {
        window.cookieconsent.formValidationFailed(validationError.html());
    }
}, false);

if (window.cookieconsent_config) {
    window.cookieconsent.initialise(window.cookieconsent_config);
}

$(function () {
    $(document).ajaxComplete(function (e, xhr) {
        if (xhr.hasOwnProperty('responseText')) {
            var response = JSON.parse(xhr.responseText);

            if (response.hasOwnProperty('invalids')) {
                var cookieConsent = response.invalids.filter(function (field) {
                    return field.into === '.form-group.pcn';
                });

                if (cookieConsent.length > 0) {
                    window.cookieconsent.formValidationFailed(cookieConsent[0].message);
                }
            }
        }
    });
});