window.cookieconsent.formValidationFailed = function (message, form = false) {
    if (window.cookieconsent_config && window.cookieconsent_config.content.formValidationMessage) {
        message = window.cookieconsent_config.content.formValidationMessage;
    }

    if (jQuery('.cc-hide-window').length <= 0) {
        jQuery('.cc-window').prepend('<span aria-label="dismiss cookie message" role=button tabindex="0" class="cc-btn cc-hide-window">&times;</span>');
    }
    jQuery('.cc-window').removeClass('cc-invisible').show();
    var link = jQuery('.cc-link');
    var oldMessage = jQuery('.cc-message').html();
    jQuery('.cc-message').html(message);
    jQuery('.cc-message').append(link);
    jQuery('.cc-overlay').show().removeClass('cc-invisible');
    jQuery('.cc-window').addClass('cc-center');
    jQuery('.cc-dismiss').on('click', function () {
        if (jQuery('.cc-window').hasClass('cc-center') && form) {
            window.cc_form = form;
            jQuery(document).trigger("cc-click", [form]);
        }
    });
    jQuery('.cc-window .cc-btn, .cc-window a').click(function (e) {
        jQuery('.cc-overlay').addClass('cc-invisible');
        if (jQuery(e.target).hasClass('cc-hide-window')) {
            jQuery('.cc-message').html(oldMessage);
            jQuery('.cc-window').removeClass('cc-center');
            jQuery(this).parent().delay(1000).queue(function (next) {
                jQuery('.cc-overlay').hide();
                next();
            });
        } else {
            jQuery(this).parent().delay(1000).queue(function (next) {
                jQuery('.cc-message').html(oldMessage);
                jQuery(this).removeClass('cc-center');
                jQuery('.cc-overlay').hide();
                next();
            });
        }
    });
};

document.addEventListener("DOMContentLoaded", function () {
    var ccOverlay = document.createElement('div');
    ccOverlay.className = 'cc-overlay cc-invisible';
    ccOverlay.style.display = 'none';
    document.getElementsByTagName('body')[0].insertBefore(ccOverlay, document.getElementsByTagName('body')[0].childNodes[0]);
});


document.addEventListener('gform_post_render', function (e, formId) {
    var validationError = jQuery('#gform_' + formId + ' .validation_error');
    if (validationError && validationError.length > 1 && validationError.hasClass('cookie-consent')) {
        window.cookieconsent.formValidationFailed(validationError.html(), jQuery('#gform_' + formId));
    }
}, false);

if (window.cookieconsent_config) {
    // Delay initialise by 100 milliseconds to ensure possible config overwrites (like translations) are done
    setTimeout(function () {
        window.cookieconsent.initialise(window.cookieconsent_config);
    }, 100);
}

jQuery(function () {
    jQuery(document).ajaxComplete(function (e, xhr) {
        if (xhr.hasOwnProperty('responseText')) {
            try {
                var response = JSON.parse(xhr.responseText);
            } catch (e) {
                return;
            }

            if (response.hasOwnProperty('cc-accept')) {
                if (window.cc_form) {
                    window.cc_form.submit();
                }
                return;
            }

            var cookieConsent = [], invalid_count;
            if (response.hasOwnProperty('invalids')) {
                cookieConsent = response.invalids.filter(function (field) {
                    return field.into.indexOf('.pcn') !== -1;
                });
                invalid_count = response.invalids.length;
            } else if (response.hasOwnProperty('invalidFields')) {
                cookieConsent = response.invalidFields.filter(function (field) {
                    return field.into.indexOf('.pcn') !== -1;
                });
                invalid_count = response.invalidFields.length;
            }

            if (cookieConsent.length > 0 && invalid_count === 1) {
                console.log('call cookie consent');
                window.cookieconsent.formValidationFailed(cookieConsent[0].message, jQuery(response.into + ' form'));
            }
        }
    });
});
