jQuery(function() {

    var form = document.getElementById('cc-options-form');
    form.onchange = function () { update(); };

    function update () {
        setCode(getOptions(getInputs(form)));
        updateForm(form);
    }

    function setCode (config) {
        optionsField = jQuery('#icc_popup_options');
        if(typeof config != 'object') {
            optionsField.val('{'+config+'}');
        }
        else {
            console.log(config);
            var code = JSON.stringify(config);
            optionsField.val(code);
        }
    }

    function getOptions(input) {
        var content = {};
        var options = {};

        var t = input.text;
        //if (t.header)  content.header = t.header;
        if (t.message) content.message = escapeHtml(t.message);
        if (t.dismiss) content.dismiss = escapeHtml(t.dismiss);
        if (t.allow)   content.allow = escapeHtml(t.allow);
        if (t.deny)    content.deny = escapeHtml(t.deny);
        if (t.link)    content.link = escapeHtml(t.link);
        if (t.formValidationMessage)    content.formValidationMessage = escapeHtml(t.formValidationMessage);
        if (t.formValidationMessage === '' || typeof t.formValidationMessage === "undefined" ) content.formValidationMessage = form.querySelector('[name="cc-form-validation-message"]').placeholder;

        if (input.layout == 'wire') {
            options.palette.button.border = options.palette.button.background;
            options.palette.button.background = 'transparent';
            options.palette.button.text =  options.palette.button.border;

        }

        //remove link if user didnt fill in field
        if(input.policy == 'policylink') {
            input.href ? content.href = input.href : options.showLink = false;
        }

        // only add if not default
        if(input.compliance != 'info') options.type = input.compliance;

        //if has any content, add content
        for(var key in content) {
            if (content.hasOwnProperty(key)) {
                options.content = content;
                break;
            }
        }

        if (isValidJson(input.custom)) {
            jQuery('#custom-attributes').css({background:"transparent"});
            jQuery('[type="submit"]').removeAttr('disabled').val('Wijzigingen opslaan');
            options = Object.assign({}, options, JSON.parse(input.custom));
        } else {
            jQuery('#custom-attributes').css({background:"#ffc0cb"});
            jQuery('[type="submit"]').attr('disabled','').val('JSON custom attributes invalid');
        }

        return options;
    }

    function getInputs (elem) {
        return {
            text: {
                allow: elem.querySelector('[name="allow-text"]').value,
                link: elem.querySelector('[name="link-text"]').value,
                message: elem.querySelector('[name="message-text"]').value,
                formValidationMessage: elem.querySelector('[name="cc-form-validation-message"]').value,
                deny: elem.querySelector('[name="deny-text"]').value,
                dismiss: elem.querySelector('[name="dismiss-text"]').value,
            },
            href: elem.querySelector('[name="link-href"]').value,
            policy: elem.querySelectorAll('[name="policy"]:checked').item(0).value,
            compliance: elem.querySelectorAll('[name="choose-cookie-compliance"]:checked').item(0).value,
            custom: elem.querySelector('[name="custom-attributes"]').value
        }
    }

    function escapeHtml(html) {
        // let the spec decide how to escape the html
        var text = document.createTextNode(html);
        var div = document.createElement('div');
        div.appendChild(text);
        return div.innerHTML;
    }

    function updateForm(form) {
        document.getElementById('text-policylink-container').style.display = (form.querySelectorAll('[name="policy"]:checked').item(0).value == 'policylink' && form.querySelector('[name="link-href"]').value == '') ? 'none' : 'inline';
        document.getElementById('text-accept-container').style.display = form.querySelectorAll('[name="choose-cookie-compliance"]:checked').item(0).value != 'opt-in' ? 'none' : 'inline';
        document.getElementById('text-deny-container').style.display = form.querySelectorAll('[name="choose-cookie-compliance"]:checked').item(0).value != 'opt-out' ? 'none' : 'inline';
    }

    function isValidJson(str) {
        try {
            JSON.parse(str);
        } catch (e) {
            return false;
        }
        return true;
    }

    update();

});