var gulp = require('gulp');
var babel = require('gulp-babel');
var uglify = require('gulp-uglify');
var rename = require('gulp-rename');
var cleanCSS = require('gulp-clean-css');
var autoprefixer = require('gulp-autoprefixer');

var paths = {
    styles: {
        src: [
            'node_modules/intl-tel-input/build/css/intlTelInput.css',
        ],
        dest: 'assets/style/'
    },
    scripts: {
        src: [
            'node_modules/intl-tel-input/build/js/utils.js',
            'node_modules/intl-tel-input/build/js/intlTelInput-jquery.js',
            '*.js',
            '!gulpfile.js',
        ],
        dest: 'assets/scripts/'
    }
};

function scripts() {
    return gulp.src(paths.scripts.src)
        .pipe(babel())
        .pipe(uglify())
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.scripts.dest));
}

function styles() {
    return gulp.src(paths.styles.src)
        .pipe(autoprefixer())
        .pipe(cleanCSS())
        .pipe(rename({
            suffix: '.min'
        }))
        .pipe(gulp.dest(paths.styles.dest));
}

function watch() {
    gulp.watch(paths.scripts.src.concat(paths.styles.src), scripts);
}

gulp.task('styles', styles);
gulp.task('scripts', scripts);
gulp.task('watch', watch);

gulp.task('default', gulp.parallel('styles', 'scripts'));