<?php

namespace yndenz\Plugins\Klantenvertellen;

class Reviews {

	/** @var int */
	public $found_reviews = 0;

	/** @var float */
	public $average = 0;

	/** @var int */
	public $last_year_found_reviews = 0;

	/** @var float */
	public $last_year_average = 0;

	/** @var float */
	public $percentage_recommending = 0;

	/** @var float */
	public $last_year_percentage_recommending = 0;

	/** @var Review[] */
	public $reviews = array();

	public static function fromCache() {
		$content = file_get_contents( KLANTENVERTELLEN_CACHE );
		if ( empty( $content ) ) {
			return null;
		}

		$data = json_decode( $content, true );
		if ( empty( $data ) ) {
			return null;
		}

		$result = new static;
		foreach ( $data as $key => $value ) {
			if ( $key === 'reviews' ) {
				$result->reviews = array_map( function ( $review ) {
					return Review::fromData( $review );
				}, $value );
			} else {
				$result->{$key} = $value;
			}
		}

		return $result;
	}

	/**
	 * Calculate the percentage of reviewers recommending the client.
	 */
	public function calculatePercentageRecommending() {
		$this->percentage_recommending = count( array_filter( $this->reviews, function ( $review ) {
				return $review->recommend;
			} ) ) / count( $this->reviews ) * 100;
	}

	/**
	 * Calculate the percentage of reviewers in the past 12 months recommending the client.
	 */
	public function calculateLastYearPercentageRecommending() {
		$this->last_year_percentage_recommending = count( array_filter( $this->reviews, function ( $review ) {
				return $review->recommend && $review->date >= strtotime( '-1 year' );
			} ) ) / count( $this->reviews ) * 100;
	}

}
