<?php
/*
Plugin Name: Klantenvertellen
Plugin URI:  http://www.yndenz.com
Description: Klantenvertellen.nl page reader for reviews
Version:     3.0.17
Author:      yndenz <developers@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: klantenvertellen
*/

use yndenz\Plugins\Klantenvertellen\Reviews;
use yndenz\Plugins\Klantenvertellen\Scraper;

/**
 * Add a menu item to the settings menu
 */
add_action( 'admin_menu', 'klantenvertellen_menu' );
function klantenvertellen_menu() {
	// Add a new submenu under Settings
	add_options_page( __( 'Klantenvertellen', 'klantenvertellen' ), __( 'Klantenvertellen', 'klantenvertellen' ), 'manage_options', 'klantenvertellen', 'klantenvertellen_settings_page' );
}

/**
 * Display the settings page
 */
function klantenvertellen_settings_page() {
	//must check that the user has the required capability
	if ( ! current_user_can( 'manage_options' ) ) {
		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
	}

	// See if the user has saved the settings
	if ( isset( $_POST['klantenvertellen_slug'] ) ) {
		// Save the posted value in the database
		update_option( 'klantenvertellen_slug', $_POST['klantenvertellen_slug'] );
		?>
        <div class="updated"><p><strong><?php _e( 'Settings saved.', 'klantenvertellen' ); ?></strong></p></div>
		<?php
	}
	?>
    <div class="wrap">
        <h2><?php _e( 'Klantenvertellen Settings', 'klantenvertellen' ); ?></h2>
        <form name="klantenvertellenSettingsForm" method="post" action="">
            <label>
				<?php _e( "Slug:", 'klantenvertellen' ); ?>
            </label>
            <input type="text" name="klantenvertellen_slug"
                   value="<?php echo get_option( 'klantenvertellen_slug' ); ?>"/>
            <button type="submit" class="button-primary"><?php _e( 'Save', 'klantenvertellen' ); ?></button>
        </form>
    </div>
	<?php
}

/**
 * Get all klantenvertellen reviews.
 * Define KLANTENVERTELLEN_CACHE if you want to cache the reviews.
 *
 * @return Reviews|bool Returns an array containing the reviews, or false if an error occurred.
 */
function klantenvertellen_get_reviews( $cron = false ) {
	set_time_limit( 300 );
	$cached_result = null;
	if ( defined( 'KLANTENVERTELLEN_CACHE' ) && file_exists( KLANTENVERTELLEN_CACHE ) ) {
		$cached_result = Reviews::fromCache();
	}

	// If the cache file is not defined or the file is updated over an hour ago, fetch the reviews
	if ( $cron || is_null( $cached_result ) ) {
		$base_url = 'https://www.klantenvertellen.nl/reviews/' . get_option( 'klantenvertellen_slug' );
		$base_url = apply_filters( 'klantenvertellen_base_url', $base_url );

		try {
			$scraper = new Scraper( $base_url, $cached_result );
			$result  = $scraper->fetchReviews();

			if ( $result->found_reviews === 0 ) {
				throw new Exception( 'No reviews' );
			}

			file_put_contents( KLANTENVERTELLEN_CACHE . '.tmp', json_encode( $result ) );
			if ( file_exists( KLANTENVERTELLEN_CACHE ) ) {
				unlink( KLANTENVERTELLEN_CACHE );
			}
			rename( KLANTENVERTELLEN_CACHE . '.tmp', KLANTENVERTELLEN_CACHE );
		} catch ( Exception $e ) {
			$result = $cached_result;
		}
	} else {
		$result = $cached_result;
	}

	ob_start();
	include locate_template( 'klantenvertellen-item-reviewed.php' );
	$result->item_reviewed = ob_get_clean();

	return $result;
}

/**
 * Get average klantenvertellen.nl rating
 */
add_shortcode( 'klantvertellen_average', 'klantvertellen_average' );
function klantvertellen_average() {
	$klantvertellen = klantenvertellen_get_reviews();

	return $klantvertellen->average;
}

/**
 * Get total klantenvertellen.nl reviews
 */
add_shortcode( 'klantvertellen_total', 'klantvertellen_total' );
function klantvertellen_total() {
	$klantvertellen = klantenvertellen_get_reviews();

	return $klantvertellen->found_reviews;
}
