jQuery(function () {
    var lazyloadImages = document.querySelectorAll('.ym-lazy');

    // Google should load all images directly (no scroll event detected)
    if (navigator.userAgent.match(/speed.insights|googlebot/i)) {
        lazyloadImages.forEach((image) => {
            image.src = image.getAttribute('data-src');
            image.srcset = image.getAttribute('data-srcset');
            image.classList.remove('ym-lazy');
        });
        return;
    }

    if ('IntersectionObserver' in window) {
        var imageObserver = new IntersectionObserver(function (entries, observer) {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    var image = entry.target;
                    image.src = image.getAttribute('data-src');
                    image.srcset = image.getAttribute('data-srcset');
                    image.classList.remove('ym-lazy');
                    observer.unobserve(image);
                }
            });
        }, {
            root: document.querySelector('body'),
            rootMargin: '0px 0px 500px 0px'
        });

        lazyloadImages.forEach((image) => {
            imageObserver.observe(image);
        });
    } else {
        var lazyloadThrottleTimeout;

        function lazyload() {
            if (lazyloadThrottleTimeout) {
                clearTimeout(lazyloadThrottleTimeout);
            }

            lazyloadThrottleTimeout = setTimeout(() => {
                lazyloadImages.forEach((image, index, object) => {
                    var offset = image.getBoundingClientRect().top;
                    if (0 < offset && offset < window.innerHeight + 500) {
                        image.src = image.getAttribute('data-src');
                        image.srcset = image.getAttribute('data-srcset');
                        image.classList.remove('ym-lazy');
                        object.splice(index, 1);
                    }
                });

                if (lazyloadImages.length === 0) {
                    jQuery(document).unbind('scroll', lazyload);
                    jQuery(window).unbind('resize', lazyload);
                }
            }, 20);
        }

        jQuery(document).on('scroll', lazyload);
        jQuery(window).on('resize', lazyload);
        lazyload();
    }
});