jQuery(function () {
    var lazyloadImages = document.querySelectorAll('.ym-lazy'), i, image;

    // Google should load all images directly (no scroll event detected)
    if (navigator.userAgent.match(/speed.insights|googlebot/i)) {
        for (i = 0; i < lazyloadImages.length; i++) {
            image = lazyloadImages[i];
            image.src = image.getAttribute('data-src');
            image.srcset = image.getAttribute('data-srcset');
            image.classList.remove('ym-lazy');
        }
    } else if ('IntersectionObserver' in window) {
        var imageObserver = new IntersectionObserver(function (entries, observer) {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    var image = entry.target;
                    image.src = image.getAttribute('data-src');
                    image.srcset = image.getAttribute('data-srcset');
                    image.classList.remove('ym-lazy');
                    observer.unobserve(image);
                }
            });
        }, {
            root: document.querySelector('body'),
            rootMargin: '0px 0px 500px 0px'
        });

        for (i = 0; i < lazyloadImages.length; i++) {
            imageObserver.observe(lazyloadImages[i]);
        }
    } else {
        var lazyloadThrottleTimeout;

        function lazyload() {
            if (lazyloadThrottleTimeout) {
                clearTimeout(lazyloadThrottleTimeout);
            }

            lazyloadThrottleTimeout = setTimeout(() => {
                var numImages = lazyloadImages.length;
                for (i = 0; i < numImages; i++) {
                    image = lazyloadImages[i];
                    var offset = image.getBoundingClientRect().top;
                    if (0 < offset && offset < window.innerHeight + 500) {
                        image.src = image.getAttribute('data-src');
                        image.srcset = image.getAttribute('data-srcset');
                        image.classList.remove('ym-lazy');
                        lazyloadImages.splice(i, 1);
                    }
                }

                if (lazyloadImages.length === 0) {
                    jQuery(document).unbind('scroll', lazyload);
                    jQuery(window).unbind('resize', lazyload);
                }
            }, 20);
        }

        jQuery(document).on('scroll', lazyload);
        jQuery(window).on('resize', lazyload);
        lazyload();
    }
});