if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.images = yndenz.modules.images || function () {
    return {};
};

yndenz.modules.images.lazy = function (target, options) {
    this.target = target;
    this.options = options;

    if (navigator.userAgent.match(/googlebot/i)) {
        this.target.loadOriginal();
        return;
    }

    this.checkLazyLoadingDisabled();

    if (!'IntersectionObserver' in window || this.options.forceJQuery === true) {
        this.initializeJQueryObserver();
    } else {
        this.initializeIntersectionObserver();
        this.observeImages();
    }
};

yndenz.modules.images.lazy.prototype.checkLazyLoadingDisabled = function () {
    var numImages = this.target.length;
    for (var i = 0; i < numImages; i++) {
        var image = this.target.eq(i);
        if (image.is('[data-disable-lazy]')) {
            this.loadOriginal(image);
            this.target.splice(i, 1);
        } else if (image.is('[data-clp]')) {
            this.target.splice(i, 1);
        }
    }
};

yndenz.modules.images.lazy.prototype.loadOriginal = function (image) {
    image.attr('src', image.attr('data-src'));
    image.attr('srcset', image.attr('data-srcset'));
    image.removeClass('ym-lazy');
};

yndenz.modules.images.lazy.prototype.initializeIntersectionObserver = function () {
    this.observer = new IntersectionObserver(jQuery.proxy(this.checkIntersecting, this), {
        rootMargin: this.options.distance + 'px 0px ' + this.options.distance + 'px 0px'
    });
};

yndenz.modules.images.lazy.prototype.checkIntersecting = function (entries) {
    entries.forEach(jQuery.proxy(this.checkIntersectingImage, this));
};

yndenz.modules.images.lazy.prototype.checkIntersectingImage = function (entry) {
    if (!entry.isIntersecting) {
        return;
    }

    this.loadOriginal(jQuery(entry.target));
    this.observer.unobserve(entry.target);
};

yndenz.modules.images.lazy.prototype.observeImages = function () {
    var observer = this.observer;
    this.target.each(function () {
        observer.observe(this);
    });
};

yndenz.modules.images.lazy.prototype.initializeJQueryObserver = function () {
    jQuery(document).on('scroll', jQuery.proxy(this.startTimeout, this));
    jQuery(window).on('resize', jQuery.proxy(this.startTimeout, this));
    this.startTimeout();
};

yndenz.modules.images.lazy.prototype.startTimeout = function () {
    if (this.timeout) {
        clearTimeout(this.timeout);
    }

    this.timeout = setTimeout(jQuery.proxy(this.checkImagesInViewport, this), 20);
};

yndenz.modules.images.lazy.prototype.checkImagesInViewport = function () {
    var numImages = this.target.length;
    for (var i = 0; i < numImages; i++) {
        var image = this.target.eq(i);

        var distance = this.options.distance;
        if (image.is('[data-distance]')) {
            distance = parseInt(image.attr('data-distance'));
        }

        var offset = image.get(0).getBoundingClientRect().top;
        var bottom = image.get(0).getBoundingClientRect().top + image.height();

        if ((0 < offset && offset < window.innerHeight + distance) ||
            (offset < 0 && bottom > -1 * distance)) {
            this.loadOriginal(image);
            this.target.splice(i, 1);
        }
    }

    if (this.target.length === 0) {
        jQuery(document).unbind('scroll', this.startTimeout);
        jQuery(window).unbind('resize', this.startTimeout);
    }
};

yndenz.modules.images.lazy.defaults = {
    distance: 200,
    forceJQuery: false
};

jQuery(function () {
    new yndenz.modules.images.lazy(jQuery('.ym-lazy'), yndenz.modules.images.lazy.defaults);
});