<?php

namespace yndenz\Plugins\NotifyYndenz;

class PHPError {

	/**
	 * Notify yndenz about PHP errors.
	 *
	 * @param int    $errno
	 * @param string $errstr
	 *
	 * @return bool
	 */
	public static function error_handler( $errno, $errstr ) {
		if ( error_reporting() === 0 ) {
			return true;
		}

		$message = array(
			'username'    => get_bloginfo( 'name' ),
			'text'        => $errstr,
			'attachments' => array(
				array(
					'title' => date( 'Y-m-d H:i:s' ),
					'text'  => self::log_trace( $errstr ),
				)
			)
		);

		if ( ! self::notify_yndenz( $message ) ) {
			mail( 'developers@yndenz.com', 'Failed to send this PHP error to yndenz Notify', print_r( $message, true ) );
		}

		return true;
	}

	/**
	 * Get the debug backtrace as a string.
	 *
	 * @return string
	 */
	private static function log_trace( $error ) {
		$trace        = array_slice( debug_backtrace(), 1 );
		$call         = array_shift( $trace );
		$call['file'] = ! empty( $call['file'] ) ? $call['file'] : '-';
		$call['line'] = ! empty( $call['line'] ) ? $call['line'] : '-';
		$message      = $error . ' in ' . $call['file'] . ' on line ' . $call['line'];
		if ( array_key_exists( 'REQUEST_URI', $_SERVER ) ) {
			$message .= ' for ' . $_SERVER['REQUEST_URI'];
		}

		foreach ( $trace as $entry_id => $entry ) {
			$entry['file'] = ! empty( $entry['file'] ) ? $entry['file'] : '-';
			$entry['line'] = ! empty( $entry['line'] ) ? $entry['line'] : '-';
			if ( empty( $entry['class'] ) ) {
				$message .= sprintf( "\r\n" . '%3s. %s() %s:%s', $entry_id + 1, $entry['function'], $entry['file'], $entry['line'] );
			} else {
				$message .= sprintf( "\r\n" . '%3s. %s%s%s() %s:%s', $entry_id + 1, $entry['class'], $entry['type'], $entry['function'], $entry['file'], $entry['line'] );
			}
		}

		return $message;
	}

	/**
	 * Notify yndenz about PHP fatal errors.
	 */
	public static function notify_shutdown() {
		$error = error_get_last();
		if ( is_null( $error ) ) {
			return;
		}

		$error_message = $error['message'];
		if ( strpos( $error_message, "\n" ) !== false ) {
			$error_message = strstr( $error_message, "\n", true );
		}
		if ( array_key_exists( 'REQUEST_URI', $_SERVER ) ) {
			$error_message .= ' for ' . $_SERVER['REQUEST_URI'];
		}

		$message = array(
			'username'    => get_bloginfo( 'name' ),
			'text'        => $error_message,
			'attachments' => array(
				array(
					'title' => date( 'Y-m-d H:i:s' ),
					'text'  => $error_message !== $error['message'] ? substr( strstr( $error['message'], "\n" ), 1 ) : $error_message,
				)
			)
		);

		if ( ! self::notify_yndenz( $message ) ) {
			mail( 'developers@yndenz.com', 'Failed to send this error to yndenz Notify', print_r( $message, true ) );
		}
	}

	/**
	 * Send errors to the yndenz notification channel.
	 *
	 * @param mixed $data
	 *
	 * @return bool
	 */
	private static function notify_yndenz( $data ) {
		$ch = curl_init( 'https://notify.yndenz.com/hooks/x5t42rJy4cqtXzNd4/XHRfTv2b2ry5skbEmPGNqaiGAowLJmEvpzPK5DegHEfT6tfJ' );
		curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'POST' );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, http_build_query( $data ) );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
		$response = curl_exec( $ch );
		curl_close( $ch );

		if ( empty( $response ) ) {
			return false;
		}

		$result = json_decode( $response, true );

		return ! empty( $result ) && array_key_exists( 'success', $result ) && $result['success'];
	}

}
