window.addEventListener('error', (e) => {
    let params = {text: ''};
    if (e.message) {
        params.type = e.message;
        params.text = e.message + ' in ' + e.filename + ' on line ' + e.lineno;
    } else {
        params.text = params.type = (e.target.src ? e.target.src : (e.target.href ? e.target.href : 'unknown')) + ' not found';
    }
    params.text += ' on ' + window.location.href;

    const xhr = new XMLHttpRequest();
    xhr.open('POST', window.ajax_url + '?action=catch_console_error', true);
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.send((params.type ? 'type=' + encodeURIComponent(params.type) + '&' : '') + 'text=' + encodeURIComponent(params.text));
}, true);
