<?php

namespace yndenz\Plugins\NotifyYndenz;

class Message {

	/**
	 * Send a message to yndenz.
	 *
	 * @param array  $content
	 * @param bool   $fallback_to_email
	 * @param string $email_subject
	 *
	 * @return bool
	 */
	public static function send( $content, $fallback_to_email, $email_subject ) {
		return self::_sendToNotify( $content ) || ( $fallback_to_email && self::_sendToEmail( $email_subject, $content ) );
	}

	/**
	 * Send the message to the yndenz notification channel.
	 *
	 * @param array $content
	 *
	 * @return bool
	 */
	private static function _sendToNotify( $content ) {
		$ch = curl_init( NOTIFY_HOOK_URL );
		curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'POST' );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, http_build_query( $content ) );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
		$response = curl_exec( $ch );
		curl_close( $ch );

		if ( empty( $response ) ) {
			return false;
		}

		$result = json_decode( $response, true );

		return ! empty( $result ) && array_key_exists( 'success', $result ) && $result['success'];
	}

	/**
	 * Send the message to the yndenz notification email.
	 *
	 * @param string $email_subject
	 * @param array  $content
	 *
	 * @return bool
	 */
	private static function _sendToEmail( $email_subject, $content ) {
		return mail( NOTIFY_EMAIL, $email_subject, print_r( $content, true ) );
	}

}
