"use strict";

window.addEventListener('error', function (e) {
    if (typeof e.message === 'undefined') {
        return;
    }
    if (document.getElementById('wrapfabtest').clientHeight <= 0 && e.message.indexOf('not found') > 0) {
        return;
    }

    var params = {text: ''};
    if (e.message) {
        params.type = e.message;
        params.text = e.message + ' in ' + e.filename + ' on line ' + e.lineno;
    } else {
        params.text = params.type = (e.target.src ? e.target.src : (e.target.href ? e.target.href : 'unknown')) + ' not found';
    }
    params.text += ' on ' + window.location.href;

    var xhr = new XMLHttpRequest();
    xhr.open('POST', window.ajax_url + '?action=catch_console_error', true);
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.send((params.type ? 'type=' + encodeURIComponent(params.type) + '&' : '') + 'text=' + encodeURIComponent(params.text));
}, true);

var f = document.querySelector('body > script'),
    e = document.createElement('div');
e.id = 'wrapfabtest';
e.innerHTML = '<div class="adBanner"></div><style>.adBanner{height:1px;width:1px;background:transparent}</style>';
f.parentNode.insertBefore(e, f);
