<?php
/*
Plugin Name: Notify yndenz
Plugin URI:  http://www.yndenz.com
Description: Notify yndenz about any problems on with a website.
Version:     1.1.5
Author:      Gido Manders <g.manders@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: notify-yndenz
*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use yndenz\Plugins\NotifyYndenz\ConsoleError;
use yndenz\Plugins\NotifyYndenz\PHPError;

register_activation_hook( __FILE__, array( ConsoleError::class, 'create_database_table' ) );

if ( defined( 'LOCAL' ) && LOCAL ) {
	return;
}

if ( ! defined( 'NOTIFY_EMAIL' ) ) {
	define( 'NOTIFY_EMAIL', 'developers@yndenz.com' );
}
if ( ! defined( 'NOTIFY_HOOK_URL' ) ) {
	define( 'NOTIFY_CONSOLE_ERRORS_HOOK_URL', 'https://notify.yndenz.com/hooks/H47y2GjxdCoDbABRC/tFgXeJ6Susz6tdYXpbAXTHBbLBPMaNaw338Ja2HvfbxAesu4' );
	define( 'NOTIFY_PHP_ERRORS_HOOK_URL', 'https://notify.yndenz.com/hooks/x5t42rJy4cqtXzNd4/XHRfTv2b2ry5skbEmPGNqaiGAowLJmEvpzPK5DegHEfT6tfJ' );
}

add_action( 'wp_enqueue_scripts', array( ConsoleError::class, 'enqueueScripts' ), 0 );
add_action( 'wp_ajax_catch_console_error', array( ConsoleError::class, 'store' ) );
add_action( 'wp_ajax_nopriv_catch_console_error', array( ConsoleError::class, 'store' ) );
add_action( 'init', array( ConsoleError::class, 'schedule_check' ) );

register_shutdown_function( array( PHPError::class, 'notify_shutdown' ) );
set_error_handler( array( PHPError::class, 'error_handler' ) );
