<?php

namespace yndenz\Plugins\NotifyYndenz;

class Message {

	/**
	 * Send a message to yndenz.
	 *
	 * @param array  $content
	 * @param bool   $fallback_to_email
	 * @param string $email_subject
	 * @param string $hook_url
	 * @param string $plainErrorMessage
	 *
	 * @return bool
	 */
	public static function send( $content, $fallback_to_email, $email_subject, $hook_url, $plainErrorMessage = '' ) {
		$initiator = debug_backtrace()[1]['class'];

		return self::_sendToNotify( $content, $hook_url, $initiator ) || ( $fallback_to_email && self::_sendToEmail( $email_subject, $content, $initiator, $plainErrorMessage ) );
	}

	/**
	 * Send the message to the yndenz notification channel.
	 *
	 * @param array $content
	 *
	 * @return bool
	 */
	private static function _sendToNotify( $content, $hook_url ) {
		$ch = curl_init( $hook_url );
		curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'POST' );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, http_build_query( $content ) );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
		$response = curl_exec( $ch );
		curl_close( $ch );

		if ( empty( $response ) ) {
			return false;
		}

		$result = json_decode( $response, true );

		if (!empty($result) && isset($result['success']) && $result['success'] === true) {
			// Check the current value of the isNotifyUp option
			if (get_option('isNotifyUp') == 'no') {
				update_option('isNotifyUp', 'yes');

				// We want to empty the php_errors table when notify is back up, this to keep the table clean
				global $wpdb;
				$wpdb->query("TRUNCATE {$wpdb->prefix}php_errors");
			}

			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * Send the message to the yndenz notification email.
	 *
	 * @param string $email_subject
	 * @param array  $content
	 * @param string $initiator
	 * @param string $plainErrorMessage
	 *
	 * @return bool
	 */
	private static function _sendToEmail( $email_subject, $content, $initiator, $plainErrorMessage ) {
		// Check the current value of the isNotifyUp option
		if (get_option('isNotifyUp') == 'yes') {
			update_option('isNotifyUp', 'no');
		}

		// Check if the initiator is the PHPError class
		if (strpos(strtolower($initiator), 'phperror') !== false) {
			global $wpdb;

			$errorMessageFound = PHPError::_checkErrorAlreadySent($plainErrorMessage, $content['attachments'][0]['title']);

			if ($errorMessageFound) {
				return;
			}


			$errorData = [];
			$errorData['error_message'] = $plainErrorMessage;
			$errorData['created_at'] = $content['attachments'][0]['title'];

			$wpdb->insert($wpdb->prefix . 'php_errors', $errorData);
		}

		return mail( NOTIFY_EMAIL, $email_subject, print_r( $content, true ) );
	}

}
