<?php

//call register settings function
add_action( 'admin_init', function(){
	register_setting( 'notify-yndenz-settings-group', NOTIFY_CONSOLE_ERRORS_HOOK_URL_OPTION );
	register_setting( 'notify-yndenz-settings-group', NOTIFY_PHP_ERRORS_HOOK_URL_OPTION );
} );

add_action( 'init',function(){
	add_action('admin_menu', function() {
		//create new top-level menu
		add_submenu_page(
			"options-general.php",
			'Yndenz Notify Settings',
			'Yndenz Notify',
			'manage_options',
			"notify-yndenz-settings",
			'notify_yndenz_settings_page' );
	});
});


function notify_yndenz_settings_page() {
	?>
	<div class="wrap">
		<h1>Yndenz Notify</h1>

        <p>Get/set these on https://notify.yndenz.com/admin/integrations</p>

		<form method="post" action="options.php">
			<?php settings_fields( 'notify-yndenz-settings-group' ); ?>
			<?php do_settings_sections( 'notify-yndenz-settings-group' ); ?>
			<table class="form-table">
				<tr valign="top">
					<th scope="row">Console Errors Hook Url</th>
					<td><input type="text" name="<?php echo NOTIFY_CONSOLE_ERRORS_HOOK_URL_OPTION; ?>" value="<?php echo esc_attr( get_option(NOTIFY_CONSOLE_ERRORS_HOOK_URL_OPTION) ); ?>" /></td>
				</tr>

				<tr valign="top">
					<th scope="row">PHP Errors Hook Url</th>
					<td><input type="text" name="<?php echo NOTIFY_PHP_ERRORS_HOOK_URL_OPTION; ?>" value="<?php echo esc_attr( get_option(NOTIFY_PHP_ERRORS_HOOK_URL_OPTION) ); ?>" /></td>
				</tr>
			</table>

			<?php submit_button(); ?>

		</form>
	</div>
<?php } ?>