<?php
/*
Plugin Name: Notify yndenz
Plugin URI:  http://www.yndenz.com
Description: Notify yndenz about any problems on with a website.
Version:     1.5.1
Author:      Gido Manders <g.manders@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: notify-yndenz
*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use yndenz\Plugins\NotifyYndenz\ConsoleError;
use yndenz\Plugins\NotifyYndenz\PHPError;

register_activation_hook( __FILE__, array( ConsoleError::class, 'create_database_table' ) );
register_activation_hook( __FILE__, array( PHPError::class, 'create_database_table' ) );

if ( defined( 'LOCAL' ) && LOCAL ) {
	return;
}

if ( ! defined( 'NOTIFY_EMAIL' ) ) {
	define( 'NOTIFY_EMAIL', 'developers@yndenz.com' );
}
if ( ! defined( 'NOTIFY_PHP_ERRORS_HOOK_URL' ) ) {
	define( 'NOTIFY_PHP_ERRORS_HOOK_URL', 'https://notify.yndenz.com/hooks/Gwrs8YnG6qzwXh5bT/f3PsSLCZtGgQWcuFav9iW6aaQKzXbekK8BGMw5Wc4XNMAE3g' );
}

if ( ! defined( 'NOTIFY_CONSOLE_ERRORS_HOOK_URL' ) ) {
	define( 'NOTIFY_CONSOLE_ERRORS_HOOK_URL', 'https://notify.yndenz.com/hooks/yCGLPHe8CAuQvzcDP/d9qopNvEDqo6wzKNeKamrZwMFqkGhiQyEJGAfwLyi5XRxwXH' );
}

define( 'NOTIFY_PHP_ERRORS_HOOK_URL_OPTION', 'notify_php_errors_hook_url' );
define( 'NOTIFY_CONSOLE_ERRORS_HOOK_URL_OPTION', 'notify_console_errors_hook_url' );

add_action( 'wp_enqueue_scripts', array( ConsoleError::class, 'enqueueScripts' ), 0 );
add_action( 'wp_ajax_catch_console_error', array( ConsoleError::class, 'store' ) );
add_action( 'wp_ajax_nopriv_catch_console_error', array( ConsoleError::class, 'store' ) );
add_action( 'init', array( ConsoleError::class, 'schedule_check' ) );

add_action( 'init',function(){
	if (get_option(NOTIFY_CONSOLE_ERRORS_HOOK_URL_OPTION) === false) {
		add_option(NOTIFY_CONSOLE_ERRORS_HOOK_URL_OPTION, NOTIFY_CONSOLE_ERRORS_HOOK_URL);
	}
	if (get_option(NOTIFY_PHP_ERRORS_HOOK_URL_OPTION) === false) {
		add_option(NOTIFY_PHP_ERRORS_HOOK_URL_OPTION, NOTIFY_PHP_ERRORS_HOOK_URL);
	}

	if (get_option('isNotifyUp') === false) {
		add_option('isNotifyUp', 'yes');
	}
});

register_shutdown_function( array( PHPError::class, 'notify_shutdown' ) );
set_error_handler( array( PHPError::class, 'error_handler' ) );

include_once "options-menu.inc.php";

checkIfNotifyIsUp();

function checkIfNotifyIsUp() {
	// If notify is up we exit this function
	if (get_option('isNotifyUp') == 'yes') {
		return;
	}

	$timeBetweenChecksInSeconds = 1800; // 30 minutes
	$currentTime = date( 'Y-m-d H:i:s');
	$currentTime = strtotime($currentTime);
	$lastCheck = strtotime(get_option('notifyLastTimeChecked'));

	// If 30 minutes haven't passed since the last check we exit this function
	if (($currentTime - $lastCheck) < $timeBetweenChecksInSeconds) {
		return;
	}

	$response = wp_remote_get( NOTIFY_PHP_ERRORS_HOOK_URL, array(
		'timeout'   => 1,
		'blocking'  => true,
		'sslverify' => true,
	));

	// Check if the response is a WP_Error object
	if (!is_wp_error($response)) {
		update_option('isNotifyUp', 'yes');

		// We want to empty the php_errors table when notify is back up, this to keep the table clean
		global $wpdb;
		$wpdb->query("TRUNCATE {$wpdb->prefix}php_errors");

		// delete option in options table
		delete_option('notifyLastTimeChecked');
	}
	else {
		// If the response is a WP_Error object we update the timestamp of the notifyLastTimeChecked option
		update_option('notifyLastTimeChecked', date('Y-m-d H:i:s'));
	}
}