<?php

namespace yndenz\Plugins\OptimizeImages;

class OptimizeImages {

    public static function init() {
        add_action('plugins_loaded', array(static::class, 'loadTextdomain'));
        add_action('admin_menu', array(static::class, 'addMenuItem'));
    }

    /**
     * Load text domain for this plugin.
     */
    public static function loadTextdomain() {
        load_plugin_textdomain('optimize-images', FALSE, basename(dirname(__FILE__)) . '/languages/');
    }

    /**
     * Add an options page to the settings menu in WP Admin.
     */
    public static function addMenuItem() {
        add_options_page(
            __('Optimize images', 'optimize-images'),
            __('Optimize images', 'optimize-images'),
            'manage_options',
            'optimize-images',
            array(static::class, 'optionsPage')
        );
    }

    /**
     * Display the options page.
     */
    public static function optionsPage() {
        include dirname(__FILE__) . '/templates/options-page.php';
    }

    public static function getPluginURL() {
        return plugin_dir_url(__FILE__);
    }

}