#!/bin/bash

function bumpPackageJson {
    version=$2
    search='("version":[[:space:]]*").+(")'
    replace="\1${version}\2"

    sed -i ".tmp" -E "s/${search}/${replace}/g" "$1"
    rm "$1.tmp"
}
function bumpMainPluginFile {
    version=$2
    search='("PLUGINVERSION",[[:space:]]*").+(")'
    replace="\1${version}\2"

    sed -i ".tmp" -E "s/${search}/${replace}/g" "$1"

    search='(Version:[[:space:]]*).+'
    replace="\1${version}"

    sed -i ".tmp" -E "s/${search}/${replace}/g" "$1"
    rm "$1.tmp"
}

composer update

version=$(composer config version)

bumpPackageJson package.json $version
bumpMainPluginFile optimize-images.php $version

npm install
npm run build

git add -A
git commit -m "Bump version"
git tag $version
git push
git push --tags