if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.plugins = yndenz.plugins || function () {
    return {};
};

yndenz.plugins.optimizeImages = yndenz.plugins.optimizeImages || function () {
    return {};
};

yndenz.plugins.optimizeImages.uploadsList = function (target) {
    this.target = target;
    this.processButton = jQuery('.yp-optimize-images__process');
    this.page = 1;
    this.numPages = null;
    this.list = [];
    this.iterify(this.list);

    this.loadFiles(this.page);

    this.processButton.on('click', jQuery.proxy(this.startProcess, this));

    return this;
};

yndenz.plugins.optimizeImages.uploadsList.prototype.iterify = function (arr) {
    var cur = -1;
    arr.next = function () {
        return (++cur >= this.length) ? false : this[cur];
    };
    arr.prev = function () {
        return (--cur < 0) ? false : this[cur];
    };
    arr.reset = function () {
        cur = -1;
    };
    arr.getPosition = function () {
        return cur;
    };
    return arr;
};

yndenz.plugins.optimizeImages.uploadsList.prototype.checkResponse = function (response, status) {
    jQuery('.yp-optimize-images__loading').hide();
    if (status !== 'success') {
        jQuery('.yp-optimize-images__failure').show();
    }
};

yndenz.plugins.optimizeImages.uploadsList.prototype.loadFiles = function (page) {
    if (this.numPages === null || page < this.numPages) {
        jQuery.ajax({
            url: ajaxurl,
            data: {action: 'optimize_images_load', page: page},
            beforeSend: function () {
                jQuery('.yp-optimize-images__no-files').hide();
                jQuery('.yp-optimize-images__loading').show();
            },
            success: jQuery.proxy(this.listFiles, this),
            complete: jQuery.proxy(this.checkResponse, this)
        });
    }
};

yndenz.plugins.optimizeImages.uploadsList.prototype.listFiles = function (response) {
    if (response.files.length === 0 && this.page === 1) {
        jQuery('.yp-optimize-images__no-files').show();
    } else {
        jQuery('.yp-optimize-images__no-files').hide();
    }

    this.numPages = response.num_pages;

    for (var i in response.files) {
        this.list.push(new yndenz.plugins.optimizeImages.file(response.files[i]));
    }
};

yndenz.plugins.optimizeImages.uploadsList.prototype.startProcess = function () {
    this.processButton.prop('disabled', true);
    this.list.reset();
    this.process();
};

yndenz.plugins.optimizeImages.uploadsList.prototype.process = function () {
    var requests = [];
    for (var i = 0; i < 3; i++) {
        var file = this.list.next();
        if (file === false) break;
        if (file.getStatus() === 'pending') requests.push(file.process());
    }

    if (requests.length > 0 && this.list.getPosition() < this.list.length) {
        jQuery.when(requests).done(jQuery.proxy(this.process, this));
    }

    if (this.list.getPosition() > this.list.length - 6) {
        this.loadFiles(this.page++);
    } else if (this.list.getPosition() >= this.list.length) {
        this.processButton.prop('disabled', false);
    }
};

jQuery(function () {
    new yndenz.plugins.optimizeImages.uploadsList(jQuery('.yp-optimize-images__list'));
});