var gulp = require('gulp');
var sass = require('gulp-sass');
var sourcemaps = require('gulp-sourcemaps');
var babel = require('gulp-babel');
var concat = require('gulp-concat');
var uglify = require('gulp-uglify');
var rename = require('gulp-rename');
var cleanCSS = require('gulp-clean-css');

var paths = {
    styles: {
        src: [
            'source/style/**/*.scss'
        ],
        dest: 'assets/style/'
    },
    scripts: {
        src: [
            'source/js/**/*.js'
        ],
        dest: 'assets/scripts/'
    },
    fonts: {
        src: [
            'node_modules/font-awesome/fonts/*.eot',
            'node_modules/font-awesome/fonts/*.svg',
            'node_modules/font-awesome/fonts/*.ttf',
            'node_modules/font-awesome/fonts/*.woff',
            'node_modules/font-awesome/fonts/*.woff2'
        ],
        dest: 'assets/fonts/'
    }
};

function styles() {
    return gulp.src(paths.styles.src)
        .pipe(sourcemaps.init())
        .pipe(sass({outputStyle: 'compressed'}).on('error', sass.logError))
        .pipe(sourcemaps.write())
        .pipe(cleanCSS())
        .pipe(concat('optimize-images.min.css'))
        .pipe(gulp.dest(paths.styles.dest));
}

function scripts() {
    return gulp.src(paths.scripts.src, {sourcemaps: true})
        .pipe(babel())
        .pipe(uglify())
        .pipe(concat('optimize-images.min.js'))
        .pipe(gulp.dest(paths.scripts.dest));
}

function fonts() {
    return gulp.src(paths.fonts.src)
        .pipe(gulp.dest(paths.fonts.dest));
}

function watch() {
    gulp.watch(paths.scripts.src, scripts);
    gulp.watch(paths.styles.src, styles);
    gulp.watch(paths.fonts.src, fonts);
}

gulp.task('styles', styles);
gulp.task('scripts', scripts);
gulp.task('fonts', fonts);
gulp.task('watch', watch);

gulp.task('default', gulp.parallel('styles', 'scripts', 'fonts'));