<?php

namespace yndenz\Plugins\OptimizeImages;

class OptimizeImages {

	public static function init() {
		add_action( 'plugins_loaded', array( static::class, 'loadTextdomain' ) );
		add_action( 'admin_menu', array( static::class, 'addMenuItem' ) );
		add_action( 'admin_enqueue_scripts', array( static::class, 'enqueue' ) );
	}

	/**
	 * Load text domain for this plugin.
	 */
	public static function loadTextdomain() {
		load_plugin_textdomain( 'optimize-images', false, basename( dirname( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * Add an options page to the settings menu in WP Admin.
	 */
	public static function addMenuItem() {
		add_options_page(
			__( 'Optimize images', 'optimize-images' ),
			__( 'Optimize images', 'optimize-images' ),
			'manage_options',
			'optimize-images',
			array( static::class, 'optionsPage' )
		);
	}

	/**
	 * Display the options page.
	 */
	public static function optionsPage() {
		include dirname( __FILE__ ) . '/templates/options-page.php';
	}

	public static function enqueue( $hook_suffix ) {
		if ( $hook_suffix === 'settings_page_optimize-images' ) {
			wp_enqueue_style( 'optimize-images-style', static::getPluginURL() . 'assets/style/optimize-images.min.css', array(), static::getVersion() );
			wp_enqueue_script( 'optimize-images-script', static::getPluginURL() . 'assets/scripts/optimize-images.min.js', array( 'jquery' ), static::getVersion(), true );
		}
	}

	public static function getPluginURL() {
		return plugin_dir_url( __FILE__ );
	}

	public static function getVersion() {
		return OPTIMIZE_IMAGES_VERSION;
	}

}