<?php
/*
Plugin Name: Product alerts
Plugin URI:  http://www.yndenz.com
Description: Met deze plugin kunnen product alert filters opgevangen worden en middels een simpele hook gecontroleerd en verstuurd worden
Version:     1.0.0
Author:      Gido Manders <g.manders@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: product-alerts
*/

add_action('init', 'register_product_alert');
function register_product_alert() {
	register_post_type('product_alert', array(
		'labels' => array(
			'name' => _x('Product alert', 'post type general name', 'product-alerts'),
			'singular_name' => _x('Product alert', 'post type singular name', 'product-alerts'),
			'menu_name' => _x('Product alerts', 'admin menu', 'product-alerts'),
			'name_admin_bar' => _x('Product alert', 'add new on admin bar', 'product-alerts'),
			'add_new' => _x('Add new', 'slide', 'product-alerts'),
			'add_new_item' => __('Add new alert', 'product-alerts'),
			'new_item' => __('New alert', 'product-alerts'),
			'edit_item' => __('Edit alert', 'product-alerts'),
			'view_item' => __('View alert', 'product-alerts'),
			'all_items' => __('All alerts', 'product-alerts'),
			'search_items' => __('Search alerts', 'product-alerts'),
			'not_found' => __('No alerts found.', 'product-alerts'),
			'not_found_in_trash' => __('No alerts found in Trash.', 'product-alerts')
		),
		'description' => __('Product alerts', 'product-alerts'),
		'public' => false,
		'publicly_queryable' => false,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_icon' => 'dashicons-warning',
		'has_archive' => false,
		'hierarchical' => false,
		'supports' => array('title')
	));
}

/**
 * Save product alert
 */
add_action('wpcf7_before_send_mail', 'wpcf7_save_product_alert');
function wpcf7_save_product_alert() {
	$submission = WPCF7_Submission::get_instance();
	$posted_data = $submission->get_posted_data();

	if (array_key_exists('save-alert', $posted_data) && boolval($posted_data['save-alert'])) {
		save_product_alert($posted_data);
	}
}

function save_product_alert($posted_data) {
	$name = apply_filters('product_alert_get_name', $posted_data);
	$email = apply_filters('product_alert_get_email', $posted_data);

	$form_content = array_filter($posted_data, function ($field_name) {
		return substr($field_name, 0, 1) !== '_';
	}, ARRAY_FILTER_USE_KEY);
	$form_content = apply_filters('product_alert_content', $form_content);

	$post_id = wp_insert_post(
		array(
			'comment_status' => 'closed',
			'ping_status' => 'closed',
			'post_author' => 1,
			'post_name' => sanitize_title($name),
			'post_title' => $name,
			'post_status' => 'publish',
			'post_type' => 'product_alert'
		)
	);

	update_post_meta($post_id, 'product_alert_content', $form_content);
	update_post_meta($post_id, 'product_alert_email_address', $email);
}

/**
 * Delete product alert by id
 *
 * @param $id
 */
function delete_product_alert($id) {
	$alert = get_post($id);
	if ($alert instanceof WP_Post) {
		wp_trash_post($id);
		do_action('after_delete_product_alert');
	} else {
		wp_redirect(home_url('/'));
	}
}

/**
 * Send product alerts
 */
add_action("wp_ajax_nopriv_send_product_alerts", "send_product_alerts");
add_action("wp_ajax_send_product_alerts", "send_product_alerts");
function send_product_alerts() {
	$alerts = get_posts(array(
		'post_type' => 'product_alert',
		'posts_per_page' => -1,
		'post_status' => 'publish'
	));

	$mails_sent = 0;

	foreach ($alerts as $index => $alert) {
		$query_args = array('posts_per_page' => - 1);

		$already_sent = get_post_meta($alert->ID, 'product_alert_already_sent', true);
		if (!empty($already_sent)) {
			$query_args['post__not_in'] = $already_sent;
		} else {
			$already_sent = array();
		}

		$form_content = get_post_meta($alert->ID, 'product_alert_content', true);
		$query = apply_filters('product_alert_query', $query_args, $form_content);

		if ($query->have_posts()) {
			$to = $alert->post_title . ' <' . get_post_meta($alert->ID, 'product_alert_email_address', true) . '>';
			$from = apply_filters('product_alert_email_from', $alert);
			$subject = apply_filters('product_alert_email_subject', $alert);

			ob_start();
			include(locate_template('mail-product-alert.php'));
			$message = ob_get_clean();

			$headers = 'From: ' . $from . "\r\n";
			$headers .= 'Reply-To: ' . $from . "\r\n";
			$headers .= 'Return-Path: ' . $from . "\r\n";
			$headers .= 'X-Mailer: PHP/' . phpversion() . "\r\n";
			$headers .= 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=' . get_bloginfo('charset') . "\r\n";

			if (wp_mail($to, $subject, $message, $headers)) {
				$datetime = current_time(get_option('date_format') . ' ' . get_option('time_format'));
				update_post_meta($alert->ID, 'occasion_alert_last_mail', $datetime);

				if ($query->posts[0] instanceof WP_Post) {
					$object_ids = array_map(function ($post) {
						return $post->ID;
					}, $query->posts);
				} else {
					$object_ids = $query->posts;
				}

				$already_sent = array_filter(array_merge($already_sent, $object_ids));
				update_post_meta($alert->ID, 'product_alert_already_sent', $already_sent);

				printf(__('Product alert sent to %s', 'product-alert'), $alert->post_title);
				$mails_sent ++;
			} else {
				printf(__('Failed to send product alert to %s', 'product-alert'), $alert->post_title);
				if (WP_DEBUG) {

				}
			}
			echo "\r\n";
		}
	}

	if ($mails_sent < 1) {
		_e('None of the product alerts resulted in an e-mail', 'product-alert');
	}

	exit;
}