<?php

namespace OTGS\Toolset\Common\Upgrade\Command;

use OTGS\Toolset\Common\Settings\FontAwesomeSetting;
use Toolset_Settings;
use Toolset_Result;

/**
 * Setup the Font Awesome library version to load at 4 (4.7.0) on existing sites.
 *
 * @since 3.6.0
 */
class FontAwesomeVersion implements \IToolset_Upgrade_Command {

	/**
	 * Run the command.
	 *
	 * @return Toolset_Result
	 */
	public function run() {
		$toolset_settings = Toolset_Settings::get_instance();
		$font_awesome_setting = new FontAwesomeSetting( $toolset_settings );

		// Update an existing site, which has no value: set to load FA 4.
		if ( false === $font_awesome_setting->load_from_options() ) {
			$font_awesome_setting->set_value( FontAwesomeSetting::FA_4 );
		}

		return new Toolset_Result( true );
	}

}
