# WebP Express

[![RIPS CodeRisk](https://coderisk.com/wp/plugin/webp-express/badge "RIPS CodeRisk")](https://coderisk.com/wp/plugin/webp-express)

Serve autogenerated WebP images instead of jpeg/png to browsers that supports WebP.

The plugin is available on the Wordpress codex ([here](https://wordpress.org/plugins/webp-express/)).
But well, it is developed ([here on github](https://github.com/rosell-dk/webp-express/)).

**News: I have added the vendor folder to the repo. To install the plugin here from github, you can simply download the zip and unzip it in your plugin folder**

## Description
Almost 4 out of 5 mobile users use a browser that is able to display webp images. Yet, on most websites, they are served jpeg images, which are typically double the size of webp images for a given quality. What a waste of bandwidth! This plugin was created to help remedy that situation. With little effort, Wordpress admins can have their site serving autogenerated webp images to browsers that supports it, while still serving jpeg and png files to browsers that does not support webp.

### The image converter
The plugin uses the [WebP Convert](https://github.com/rosell-dk/webp-convert) library to convert images to webp. *WebP Convert* is able to convert images using multiple methods. There are the "local" conversion methods: `imagick`, `cwebp`, `vips`, `gd`. If none of these works on your host, there are the cloud alternatives: `ewww` (paid) or connecting to a Wordpress site where you got WebP Express installed and you enabled the "web service" functionality.

### The "Serving webp to browsers that supports it" part.

The plugin supports different ways of delivering webps to browsers that supports it:

1. By routing jpeg/png images to the corresponding webp - or to the image converter if the image hasn't been converted yet.
2. By altering the HTML, replacing image tags with *picture* tags. Missing webps are auto generated upon visit.
3. By altering the HTML, replacing image URLs so all points to webp. The replacements only being made for browsers that supports webp. Again, missing webps are auto generated upon visit.
4. In combination with *Cache Enabler*, the same as above can be achieved, but with page caching.
5. You can also deliver webp to *all* browsers and add the [webpjs](http://webpjs.appspot.com) javascript, which provides webp support for browsers that doesn't support webp natively. However, beware that the javascript doesn't support srcset attributes, which is why I haven't added that method to the plugin (yet).

The plugin implements the "WebP On Demand" solution described [here](https://github.com/rosell-dk/webp-convert/blob/master/docs/v2.0/webp-on-demand/webp-on-demand.md) and builds on a bunch of open source libraries (all maintained by me):
- [WebPConvert](https://github.com/rosell-dk/webp-convert): For converting images to webp
- [WebP Convert Cloud Service](https://github.com/rosell-dk/webp-convert-cloud-service): For the Web Service functionality
- [DOM Util for WebP](https://github.com/rosell-dk/dom-util-for-webp): For the Alter HTML functionality
- [Image MimeType Guesser](https://github.com/rosell-dk/image-mime-type-guesser): For detecting mime types of images.

### Benefits
- Much faster load time for images in browsers that supports webp. The converted images are typically *less than half the size* (for jpeg), while maintaining the same quality. Bear in mind that for most web sites, images are responsible for the largest part of the waiting time.
- Better user experience (whether performance goes from terrible to bad, or from good to impressive, it is a benefit)
- Better ranking in Google searches (performance is taken into account by Google)
- Less bandwidth consumption - makes a huge difference in the parts of the world where the internet is slow and costly (you know, ~80% of the world population lives under these circumstances).
- Currently ~83% of all traffic, and ~80% of mobile browsing traffic are done with browsers supporting webp. With Mozilla and Microsoft [finally on board](https://medium.com/@richard_90141/webp-image-support-an-8-year-saga-7aa2bedb8d02), these numbers are bound to increase. Check current numbers on  [caniuse.com](https://caniuse.com/webp)).
- It's great for the environment too! Reducing network traffic reduces electricity consumption which reduces CO2 emissions.

### Recent news
Feb 2019: Multisite is now supported (0.12.0)
Jan 2019: Plugin can now alter HTML (0.11.0)

## Installation
1. Upload the plugin files to the `/wp-content/plugins/webp-express` directory, or install the plugin through the WordPress plugins screen directly.
2. Activate the plugin through the 'Plugins' screen in WordPress
3. Configure it (the plugin doesn't do anything until configured)
4. Verify that it works

### Configuring
You configure the plugin in *Settings > WebP Express*.

#### Operation modes
As sort of a main switch, you can choose between the following modes of operation:

*Varied image responses*:
WebP Express creates redirection rules for images, such that a request for a jpeg will result in a webp – but only if the request comes from a webp-enabled browser. If a webp already exists, it is served immediately. Otherwise it is converted and then served. Note that not all CDN's handles varied responses well.

*CDN friendly*:
In "CDN friendly" mode, a jpeg is always served as a jpeg. Instead of varying the image response, WebP Express alters the HTML for webp usage.

*Just redirect*:
In "just redirect" mode, WebP Express is used just for redirecting jpeg and pngs to existing webp images in the same folder. So in this mode, WebP express will not do any converting. It may be that you use another plugin for that, or that you converted the images off-line and uploaded them manually.

*Tweaked*:
Here you have all options available.


#### Conversion methods
WebP Express has a bunch of methods available for converting images: Executing cwebp binary, Gd extension, Imagick extension, Vips extension, ewww cloud converter and remote WebP express etc. Each requires *something*. In many cases, one of the conversion methods will be available. You can quickly identify which converters are working - there is a green icon next to them. Hovering conversion methods that are not working will show you what is wrong.

In case no conversion methods are working out of the box, you have several options:
- You can install this plugin on another website, which supports a local conversion method and connect to that using the "Remote WebP Express" conversion method
- You can [purchase a key](https://ewww.io/plans/) for the ewww cloud converter. They do not charge credits for webp conversions, so all you ever have to pay is the one dollar start-up fee :)
- You can set up [webp-convert-cloud-service](https://github.com/rosell-dk/webp-convert-cloud-service) on another server and connect to that. Its open source.
- You can try to meet the server requirements of cwebp, Gd, Imagick, Gmagick or Vips. Check out [this wiki page](https://github.com/rosell-dk/webp-convert/wiki/Meeting-the-requirements-of-the-converters) on how to do that

### Quality detection of jpegs
If your server has Imagick extension or is able to execute imagemagick binary, the plugin will be able to detect the quality of a jpeg, and use that quality for the converted webp. You can tell if the quality detection is available by hovering the help icon in Conversion > Jpeg options > Quality for lossy. The last line in that help text tells you.

This auto quality has benefits over fixed quality as it ensures that each conversion are converted with an appropriate quality. Encoding low quality jpegs to high quality webps does not magically increase the visual quality so that your webp looks better than the original. But it does result in a much larger filesize than if the jpeg where converting to a webp with the same quality setting as the original.

If you do not have quality detection working, you can try one of the following:
- Install Imagick on the server (for this purpose, it is not required that it is compiled with WebP support)
- Install imagemagick on the server and grant permission for PHP to use the "exec" function.
- Use "Remote WebP Express" converter to connect to a site, that *does* have quality detection working
- If you have cwebp converter available, you can configure it to aim for a certain reduction, rather than using the quality parameter. Set this to for example 50%, or even 45%.

### Verifying that it works.
Once, you have a converter, that works, when you click the "test"-button, you are ready to test the whole stack, and the rewrite rules. To do this, first make sure to select something other than "Do not convert any images!" in *Image types to convert*. Next, click "Save settings". This will save settings, as well as update the *.htaccess*.

If you are working in a browser that supports webp (ie Google Chrome), you will see a link "Convert test image (show debug)" after a successful save. Click that to test if it works. The screen should show a textual report of the conversion process. If it shows an image, it means that the *.htaccess* redirection isn't working. It may be that your server just needs some time. Some servers has set up caching. It could also be that your images are handled by nginx.

Note that the plugin does not change any HTML (unless you enabled the *Alter HTML* option). In the HTML the image src is still set to ie "example.jpg". To verify that the plugin is working (without clicking the test button), do the following:

- Open the page in Google Chrome
- Right-click the page and choose "Inspect"
- Click the "Network" tab
- Reload the page
- Find a jpeg or png image in the list. In the "type" column, it should say "webp"

In order to test that the image is not being reconverted every time, look at the Response headers of the image. There should be a "X-WebP-Convert-Status" header. It should say "Serving existing converted image" the first time, but "Serving existing converted image" on subsequent requests (WebP-Express is based upon [WebP Convert](https://github.com/rosell-dk/webp-convert)).

You can also append `?debug` after any image url, in order to run a conversion, and see the conversion report. Also, if you append `?reconvert` after an image url, you will force a reconversion of the image.

### Notes

*Note:*
The redirect rules created in *.htaccess* are pointing to a PHP script. If you happen to change the url path of your plugins, the rules will have to be updated. The *.htaccess* also passes the path to wp-content (relative to document root) to the script, so the script knows where to find its configuration and where to store converted images. So again, if you move the wp-content folder, or perhaps moves Wordpress to a subfolder, the rules will have to be updated. As moving these things around is a rare situation, WebP Express are not using any resources monitoring this. However, it will do the check when you visit the settings page.

*Note:*
Do not simply remove the plugin without deactivating it first. Deactivation takes care of removing the rules in the *.htaccess* file. With the rules there, but converter gone, your Google Chrome visitors will not see any jpeg images.


## Limitations

* The plugin [should now work on Microsoft IIS server](https://github.com/rosell-dk/webp-express/pull/213), but it has not been tested thoroughly.

## Frequently Asked Questions

### How do I verify that the plugin is working?
See the "Verifying that it works section"

### No conversions methods are working out of the box
Don't fret - you have options!

- If you a controlling another WordPress site (where the local conversion methods DO work), you can set up WebP Express there, and then connect to it by configuring the “Remote WebP Express” conversion method.
- You can also setup the ewww conversion method. To use it, you need to purchase an api key. They do not charge credits for webp conversions, so all you ever have to pay is the one dollar start-up fee 🙂 (unless they change their pricing – I have no control over that). You can buy an api key here: https://ewww.io/plans/
- I have written a [template letter](https://github.com/rosell-dk/webp-convert/wiki/A-template-letter-for-shared-hosts) which you can send to your webhost
- You can try to get one of the local converters working. Check out [this page](https://github.com/rosell-dk/webp-convert/wiki/Meeting-the-requirements-of-the-converters) on the webp-convert wiki. There is also this [test/troubleshooting script](https://github.com/rosell-dk/webp-convert/wiki/A-PHP-script-for-the-webhost) which is handy when messing around with this.
- Finally, if you have access to another server and are comfortable with installing projects with composer, you can install [webp-convert-cloud-service](https://github.com/rosell-dk/webp-convert-cloud-service). It's open source.

Of course, there is also the option of using another plugin altogether. I can recommend Optimole. If you want to try that out and want to support me in the process, [follow this link](https://optimole.pxf.io/20b0M). It is an affiliate link and will give me a reward in case you decide to sign up.

### It doesn't work - Although test conversions work, it still serves jpeg images.
Actually, you might be mistaking, so first, make sure that you didn't make the very common mistake of thinking that something with the URL *example.com/image.jpg* must be a jpeg image. The plugin serves webp images on same URL as the original (unconverted) images, so do not let appearances fool you! Confused? See next FAQ item.

Assuming that you have inspected the *content type* header, and it doesn't show "image/webp", please make sure that:
1) You tested with a browser that supports webp (such as Chrome)
2) The image URL you are looking at are not pointing to another server (such as gravatar.com)

Assuming that all above is in place, please look at the response headers to see if there is a *X-WebP-Convert-Status* header. If there isn't, well, then it seems that the problem is that the image request isn't handed over to WebP Express. Reasons for that can be:

- You are on NGINX (or an Apache/Nginx combination). NGINX requires special attention, please look at that FAQ item
- You are on WAMP. Please look at that FAQ item

I shall write more on this FAQ item... Stay tuned.

### How can a webp image be served on an URL ending with "jpg"?
Easy enough. Browsers looks at the *content type* header rather than the URL to determine what it is that it gets. So, although it can be confusing that the resource at *example.com/image.jpg* is a webp image, rest assured that the browsers are not confused. To determine if the plugin is working, you must therefore examine the *content type* response header rather than the URL. See the "How do I verify that the plugin is working?" Faq item.

I am btw considering making an option to have the plugin redirect to the webp instead of serving immediately. That would remove the apparent mismatch between file extension and content type header. However, the cost of doing that will be an extra request for each image, which means extra time and worse performance. I believe you'd be ill advised to use that option, so I guess I will not implement it. But perhaps you have good reasons to use it? If you do, please let me know!

### Blank images in Safari?
WebP Express has three ways of distributing webp to webp-enabled browsers while still sending the originals to webp-disabled browsers. While method 1 can be combined with any of the other methods, you would usually just pick method 1 or one of the others if method 1 cannot be used for you.

Can some of these go wrong?
Yes. All!

#### Method 1: Varied image responses
The "Varied image responses" method adds rules to the `.htaccess` which redirects jpegs and pngs to the corresponding webps (if they exist). The rules have a condition that makes sure they only trigger for browsers supports webp images (this is established by examining the "accept" header).

I the method "varied image responses" because the response on a given image URL *varies* (the webp is served on the same URL as the jpeg/png).

In the cases where method 1 fails, it is due to systems that cache images by the URL alone. To prevent this from happening, the `.htaccess` rules adds a `Vary:Accept` response header. However, most CDNs does not respect that header unless they are configured to do so. Fortunately proxy servers respects it nicely (however often by throwing out the cached image if the accept header doesn't match)

Method 1 can go wrong if:

1. You are using a CDN and it hasn't been set up to handle varied image responses. If this has happened, it is critical that you purge the CDN cache! For information regarding CDN setups, check out the CDN section in this FAQ
2. Your server doesn't support adding response headers in `.htaccess`. On Apache, the "mod_headers" module needs to be enabled. Otherwise the all important `Vary:Accept` response header will not be set on the response.
3. Your server doesn't support SetEnv. However, that module is fortunately very common. I have posted a possible solution to make the rules work without SetEnv [here](https://wordpress.org/support/topic/setenv/).
4. You are on Nginx and you haven't created rules that adds the `Vary:Accept` header.

I do not believe it can go wrong in other ways. To be certain, please check out [this test page](http://toste.dk/rh.php). When visiting the test-page with Safari, you should see two images with the “JPG” label over them. When visiting the test-page with a browser that supports webp, you should see two images with the “WEBP” label over them. If you do not see one of these things, please report! (no-one has yet experienced that).

Since WebP Express 0.15.0 you can use the "Live test" button to check that browsers not supporting webp gets the original files and that the Vary:Accept header is returned. Note however that it may not detect CDN caching problems if the CDN doesn't cache a new image immediately - and across all its nodes.

#### Method 2: Altering HTML to use picture tags
IMG tags are replaced with PICTURE tags which has two sources. One of them points to the webp and has the "content-type" set to "image/webp". The other points to the original. The browser will select the webp source if it supports webp and the other source if it doesn't.

Method 2 can go wrong on old browser that doesn't support the picture tag syntax. However, simply enable the "Dynamically load picturefill.js on older browsers" option, and it will take care of that issue.

#### Method 3: Altering HTML to point directly to webps in webp enabled browsers
In this solution, the URLs in the HTML are modified for browsers that supports webp. Again, this is determined by examining the "accept" header. So, actually the complete page HTML varies with this method.

Method 3 can go wrong if you are using a page caching plugin if that plugin does not create a separate webp cache for webp-enabled browsers. The *Cache Enabler* plugin handles this. I don't believe there are other page caching plugins that does. There is a FAQ section in this FAQ describing how to set *Cache Enabler* up to work in tandem with WebP Express.

Note that Firefox 66+ unfortunately stopped including "image/webp" in the "accept" header it sends when requesting *the page*. While Firefox 66+ fortunately still includes "image/webp" in its accept header *for images*. That will however not get it webp images when using method 3.


### I am on NGINX or OpenResty

WebP Express works well on NGINX, however the UI is not streamlined NGINX yet. And of course, NGINX does not process the .htaccess files that WebP Express generates. WebP Express can be used without redirection, as it can alter HTML to use picture tags which links to the webp alternative. See "The simple way" below. Or, you can get your hands dirty and set up redirection in NGINX guided by the "The advanced way" section below.

#### The simple way (no redirecting rules)
The easy solution is simply to use the plugin in "CDN friendly" mode, do a bulk conversion (takes care of converting existing images), activate the "Convert on upload" option (takes care of converting new images in the media library) and enable Alter HTML (takes care of delivering webp to webp enabled browsers while still delivering the original jpeg/png to browsers not supporting webp).

*PRO*: Very easy to set up.
*CON*: Images in external CSS and images being dynamically added with javascript will not be served as webp.
*CON*: New new theme images will not be converted until you run a new Bulk conversion

#### The advanced way (creating NGINX redirecting rules)
Creating NGINX rules requires manually inserting redirection rules in the NGINX configuration file (nginx.conf or the configuration file for the site, found in `/etc/nginx/sites-available`). If you do not have access to do that, you will have to settle with the "simple way" described above.

There are two different approaches to achieve the redirections. The one that I recommend is based on a *try_files* directive. If that doesn't work for you, you can try the alternative rules that are based on the *rewrite* directive. The rules are described in the next couple of sections.

For multisite on NGINX, read [here](https://github.com/rosell-dk/webp-express/issues/8)

#### Recommended rules (using "try_files")

__Preparational step:__
The rules looks for existing webp files by appending ".webp" to the URL. So for this to work, you must configure *WebP Express* to store the converted files like that by setting *General > File extension* to *Append ".webp"*

__The rules:__
Insert the following in the `server` context of your configuration file (usually found in `/etc/nginx/sites-available`). "The `server` context" refers to the part of the configuration that starts with "server {" and ends with the matching "}".

```nginx
# WebP Express rules
# --------------------
location ~* ^/?wp-content/.*\.(png|jpe?g)$ {
  add_header Vary Accept;
  expires 365d;
  if ($http_accept !~* "webp"){
    break;
  }
  try_files
    /wp-content/webp-express/webp-images/doc-root/$uri.webp
    $uri.webp
    /wp-content/plugins/webp-express/wod/webp-on-demand.php?xsource=x$request_filename&wp-content=wp-content
    ;
}

# Route requests for non-existing webps to the converter
location ~* ^/?wp-content/.*\.(png|jpe?g)\.webp$ {
    try_files
      $uri
      /wp-content/plugins/webp-express/wod/webp-realizer.php?xdestination=x$request_filename&wp-content=wp-content
      ;
}
# ------------------- (WebP Express rules ends here)
```

__BEWARE:__
- Beware that when copy/pasting you might get html-encoded characters. Verify that the ampersand before "wp-content" isn't encoded (in the last line in the try_files block)

- Beware that the rules looks for existing webp files by appending ".webp" to the URL. So for this to work, you __must__ configure *WebP Express* to store the converted files like that.

- Beware that if you haven't enabled *png* conversion, you should replace "(png|jpe?g)" with "jpe?g".

- Beware that if you have moved wp-content to a non-standard place, you must change accordingly. Note that you must then also change the "wp-content" parameter to the script. It expects a relative path to wp-content (from document root) and is needed so the script can find the configuration file.

- Beware that there is a hack out there for permalinks which is based on "rewrite" (rather than the usual solution which is based on try_files). If you are using that hack to redirect missing files to index.php, you need to modify it as specified [here](https://wordpress.org/support/topic/nginx-server-404-not-found-when-convert-test-images/page/2/#post-11952444)

- I have put in an expires statement for caching. You might want to modify or disable that.

- The rules contains all redirections (as if you enabled all three redirection options in settings). If you do not wish to redirect to converter, remove the last line in the try_files block. If you do not wish to create webp files upon request, remove the last location block.

- If you have configured WebP Express to store images in separate folder, you do not need the "$uri.webp" line in the first "try_files" block. But it doesn't hurt to have it. And beware that the reverse is not true. If configured to store images in the same folder ("mingled"), you still need the line that looks for a webp in the separate folder. The reason for this is that the "mingled" only applies to the images in the upload folder - other images - such as theme images are always stored in a separate folder.

If you cannot get this to work then perhaps you need to add the following to your *mime.types* configuration file:
 `image/webp  webp;`

If you still cannot get it to work, you can instead try the alternative rules below.

Credits: These rules are builds upon [Eugene Lazutkins solution](http://www.lazutkin.com/blog/2014/02/23/serve-files-with-nginx-conditionally/).

#### Alternative rules (using "rewrite")

In case the recommended rules does not work for you, you can try these alternative rules.

The reason I recommend the *try_files* approach above over these alternative rules is that it is a bit simpler and it is supposed to perform marginally better. These alternative rules are in no way inferior to the other. Choose whatever works!

__Preparational step:__
The rules looks for existing webp files by appending ".webp" to the URL. So for this to work, you must configure *WebP Express* to store the converted files like that by setting *General > File extension* to *Append ".webp"*. Also make sure that WebP Express is configured with "Destination" set to "Mingled".

__The rules:__
Insert the following in the `server` context of your configuration file (usually found in `/etc/nginx/sites-available`). "The `server` context" refers to the part of the configuration that starts with "server {" and ends with the matching "}".

```nginx
# WebP Express rules
# --------------------
location ~* ^/wp-content/.*\.(png|jpe?g)$ {
    add_header Vary Accept;
    expires 365d;
}
location ~* ^/wp-content/.*\.webp$ {
    expires 365d;
    if ($whattodo = AB) {
        add_header Vary Accept;
    }
}
if ($http_accept ~* "webp"){
    set $whattodo A;
}
if (-f $request_filename.webp) {
    set $whattodo  "${whattodo}B";
}
if ($whattodo = AB) {
    rewrite ^(.*) $1.webp last;
}
if ($whattodo = A) {
    rewrite ^/wp-content/.*\.(jpe?g|png)$ /wp-content/plugins/webp-express/wod/webp-on-demand.php?xsource=x$request_filename&wp-content=wp-content break;
}
# ------------------- (WebP Express rules ends here)
```

__BEWARE:__

- Beware that when copy/pasting you might get html-encoded characters. Verify that the ampersand before "wp-content" isn't encoded (in the last line in the try_files block)

- Beware that the rules looks for existing webp files by appending ".webp" to the URL. So for this to work, you __must__ configure *WebP Express* to store the converted files like that.

- Beware that if you haven't enabled *png* conversion, you should replace "(png|jpe?g)" with "jpe?g".

- Beware that if you have moved wp-content to a non-standard place, you must change accordingly. Note that you must then also change the "wp-content" parameter to the script. It expects a relative path to wp-content (from document root) and is needed so the script can find the configuration file.

- Beware that there is a hack out there for permalinks which is based on "rewrite" (rather than the usual solution which is based on try_files). If you are using that hack to redirect missing files to index.php, you need to modify it as specified [here](https://wordpress.org/support/topic/nginx-server-404-not-found-when-convert-test-images/page/2/#post-11952444)

- I have put in an expires statement for caching. You might want to modify or disable that.

- I have not set any expire on the webp-on-demand.php request. This is not needed, as the script sets this according to what you set up in WebP Express settings. Also, trying to do it would require a new location block matching webp-on-demand.php, but that would override the location block handling php files, and thus break the functionality.

- There is no longer any reason to add "&$args" to the line begining with "/wp-content". It was there to enable debugging a single image by appending "?debug" to the url. I however removed that functionality from `webp-on-demand.php`.

It is possible to put this stuff inside a `location` directive. However, having `if` directives inside `location` directives [is considered evil](https://www.nginx.com/resources/wiki/start/topics/depth/ifisevil/). But it seems that in our case, it works. If you wish to do that, use the following rules instead:

```nginx
# WebP Express rules
# --------------------
location ~* ^/wp-content/.*\.(png|jpe?g)$ {
    add_header Vary Accept;
    expires 365d;

    if ($http_accept ~* "webp"){
        set $whattodo A;
    }
    if (-f $request_filename.webp) {
        set $whattodo  "${whattodo}B";
    }
    if ($whattodo = AB) {
        rewrite ^(.*) $1.webp last;
    }
    if ($whattodo = A) {
        rewrite ^/wp-content/.*\.(jpe?g|png)$ /wp-content/plugins/webp-express/wod/webp-on-demand.php?xsource=x$request_filename&wp-content=wp-content last;
    }
}

location ~* ^/wp-content/.*\.webp$ {
    expires 365d;
    if ($whattodo = AB) {
        add_header Vary Accept;
    }
}
# ------------------- (WebP Express rules ends here)
```

PS: In case you only want to redirect images to the script (and not to existing), the rules becomes much simpler:

```nginx
# WebP Express rules
# --------------------
if ($http_accept ~* "webp"){
  rewrite ^/(.*).(jpe?g|png)$ /wp-content/plugins/webp-express/wod/webp-on-demand.php?xsource=x$request_filename&wp-content=wp-content break;
}
# ------------------- (WebP Express rules ends here)
```

Discussion on this topic [here](https://wordpress.org/support/topic/nginx-rewrite-rules-4/)
And here: https://github.com/rosell-dk/webp-express/issues/166

Here are rules if you need to *replace* the file extension with ".webp" rather than appending ".webp" to it: https://www.keycdn.com/support/optimus/configuration-to-deliver-webp

### I am on a Windows server
Good news! It should work now, thanks to a guy that calls himself lwxbr. At least on XAMPP 7.3.1, Windows 10. https://github.com/rosell-dk/webp-express/pull/213.

### I am using Jetpack
If you install Jetpack and enable the "Speed up image load times" then Jetpack will alter the HTML such that images are pointed to their CDN.

Ie:
`<img src="https://example.com/wp-content/uploads/2018/09/architecture.jpg">`

becomes:
`<img src="https://i0.wp.com/example.com/wp-content/uploads/2018/09/architecture.jpg">`

Jetpack automatically serves webp files to browsers that supports it using same mechanism as the standard WebP Express configuration: If the "Accept" header contains "image/webp", a webp is served (keeping original file extension, but setting the "content-type" header to "image/webp"), otherwise a jpg is served.

As images are no longer pointed to your original server, the .htaccess rules created by WebP Express will not have any effect.

So if you are using Jetpack you don't really need WebP Express?
Well, there is no point in having the "Speed up image load times" enabled together with WebP Express.

But there is a case for using WebP Express rather than Jetpacks "Speed up image load times" feature:

Jetpack has the same drawback as the *Varied image responses* operation mode: If a user downloads the file, there will be a mismatch between the file extension and the image type (the file is ie called "logo.jpg", but it is really a webp image). I don't think that is a big issue, but for those who do, WebP Express might still be for you, even though you have Jetpack. And that is because WebP Express can be set up just to generate webp's, without doing the internal redirection to webp (will be possible from version 0.10.0). You can then for example use the [Cache Enabler](https://wordpress.org/plugins/cache-enabler/) plugin, which is able to generate and cache two versions of each page. One for browsers that accepts webp and one for those that don't. In the HTML for webp-enabled browsers, the images points directly to the webp files.

Pro Jetpack:
- It is a free CDN which serves webp out of the box.
- It optimizes jpegs and pngs as well (but note that only about 1 out of 5 users gets these, as webp is widely supported now)

Con Jetpack:
- It is a big plugin to install if you are only after the CDN
- It requires that you create an account on Wordpress.com

Pro WebP Express:
- You have control over quality and metadata
- It is a small plugin and care has been taken to add only very little overhead
- Plays well together with Cache Enabler. By not redirecting jpg to webp, there is no need to do any special configuration on the CDN and no issue with misleading file extension, if user downloads a file.

Con WebP Express:
- If you are using a CDN and you are redirecting jpg to webp, you must configure the CDN to forward the Accept header. It is not possible on all CDNs.

### Why do I not see the option to set WebP quality to auto?
The option will only display, if your system is able to detect jpeg qualities. To make your server capable to do that, install *Imagick extension* (PECL >= 2.2.2) or enable exec() calls and install either *Imagick* or *Gmagick*.

If you have the *Imagick*, the *Imagick binary* or the *Remote WebP Express* conversion method working, but don't have the global "auto" option, you will have the auto option available in options of the individual converter.

Note: If you experience that the general auto option doesn't show, even though the above-mentioned requirements should be in order, check out [this support-thread](https://wordpress.org/support/topic/still-no-auto-option/).

### How do I configure my CDN ("Varied image responses" mode)?
In *Varied image responses* operation mode, the image responses *varies* depending on whether the browser supports webp or not (which browsers signals in the *Accept* header). Some CDN's support this out of the box, others requires some configuration and others doesn't support it at all.

For a CDN to cooperate, it needs to
1) forward the *Accept* header and
2) Honour the Vary:Accept response header.

You can also make it "work" on some CDN's by bypassing cache for images. But I rather suggest that you try out the *CDN friendly* mode (see next FAQ item)

#### Status of some CDN's

- *KeyCDN*: Does not support varied image responses. I have added a feature request [here](https://community.keycdn.com/t/support-vary-accept-header-for-conditional-webp/1864). You can give it a +1 if you like!
- *Cloudflare*: See the "I am on Cloudflare" item
- *Cloudfront*: Works, but needs to be configured to forward the accept header. Go to *Distribution settings*, find the *Behavior tab*, select the Behavior and click the Edit button. Choose *Whitelist* from *Forward Headers* and then add the "Accept" header to the whitelist.

I shall add more to the list. You are welcome to help out [here](https://wordpress.org/support/topic/which-cdns-works-in-standard-mode/).

### How do I make it work with CDN? ("CDN friendly" mode)
In *CDN friendly* mode, there is no trickery with varied image responses, so no special attention is required *on the CDN*.

However, there are other pitfalls.

The thing is that, unless you have the whole site on a CDN, you are probably using a plugin that *alters the HTML* in order to point your static assets to the CDN. If you have enabled the "Alter HTML" in WebP Express, it means that you now have *two alterations* on the image URLs!

How will that play out?

Well, if *WebP Express* gets to alter the HTML *after* the image URLs have been altered to point to a CDN, we have trouble. WebP Express does not alter external images but the URLs are now external.

However, if *WebP Express* gets to alter the HTML *before* the other plugin, things will work fine.

So it is important that *WebP Express* gets there first.

*The good news is that WebP Express does get there first on all the plugins I have tested.*

But what can you do if it doesn't?

Firstly, you have an option in WebP Express to select between:
1. Use content filtering hooks (the_content, the_excerpt, etc)
2. The complete page (using output buffering)

The content filtering hooks gets to process the content before output buffering does. So in case output buffering isn't early enough for you, choose the content filtering hooks.

There is a risk that you CDN plugin also uses content filtering hooks. I haven't encountered any though. But if there is any out there that does, chances are that they get to process the content before WebP Express, because I have set the priority of these hooks quite high (10000). The reasoning behind this is to that we want to replace images that might be inserted using the same hook (for example, a theme might use *the_content* filter to insert the featured image). If you do encounter a plugin for changing URLs for CDN which uses the content filtering hooks, you are currently out of luck. Let me know, so I can fix that (ie. by making the priority configurable)

Here are a list of some plugins for CDN and when they process the HTML:

| Plugin            | Method             | Hook(s)                                          | Priority
| ----------------- | ------------------ | ------------------------------------------------ | ---------------
| BunnyCDN          | Output buffering   | template_redirect                                | default (10)
| CDN enabler       | Output buffering   | template_redirect                                | default (10)
| Jetpack           | content filtering  | the_content, etc                                 | the_content: 10
| W3 Total Cache    | Output buffering   | no hooks. Buffering is started before hooks      |
| WP Fastest Cache  | Output buffering   | no hooks. Buffering is started before hooks      |
| WP Super Cache    | Output buffering   | init                                             | default (10)


With output buffering the plugin that starts the output buffering first gets to process the output last. So WebP Express starts as late as possible, which is on the `template_redirect` hook, with priority 10000 (higher means later). This is later than the `init` hook, which is again later than the `no hooks`.


### I am on Cloudflare
Without configuration, Cloudflare will not maintain separate caches for jpegs and webp; all browsers will get jpeg. To make Cloudflare cache not only by URL, but also by header, you need to use the [Custom Cache Key](https://support.cloudflare.com/hc/en-us/articles/115004290387) page rule, and add *Header content*  to make separate caches depending on the *Accept* request header.

However, the *Custom Cache Key* rule currently requires an *Enterprise* account. And if you already have that, you may as well go with the *Polish* feature, which starts at the “Pro” level plan. With the *Polish* feature, you will not need WebP Express.

To make *WebP Express* work on a free Cloudflare account, you have the following choices:

1. You can configure the CDN not to cache jpeg images by adding the following page rule: If rule matches: `example.com/*.jpg`, set: *Cache level* to: *Bypass*

2. You can set up another CDN (on another provider), which you just use for handling the images. You need to configure that CDN to forward the *Accept header*. You also need to install a Wordpress plugin that points images to that CDN.

3. You can switch operation mode to "CDN friendly" and use HTML altering.

### I am on WP Engine
From version 0.17.1 on WebP Express works with WP engine and this combination will be tested before each release.

You can use the plugin both in "Varied image responses" mode and in "CDN friendly mode".

To make the redirection work, you must:
1) Grab the nginx configuration found in the "I am on Nginx/OpenResty" section in this FAQ. Use the "try_files" variant.
2) Contact help center and ask them to insert that configuration.
3) Make sure the settings match this configuration. Follow the "beware" statements in the "I am on Nginx/OpenResty" section.

WebP Express tweaks the workings of "Redirect to converter" a bit for WP engine. That PHP script usually serves the webp directly, along with a Vary:Accept header. This header is however overwritten by the caching machinery on WP engine. As a work-around, I modified the response of the script for WP engine. Instead of serving the image, it serves a redirect to itself. As there now IS a corresponding webp, this repeated request will not be redirected to the PHP script, but directly to the webp. And headers are OK for those redirects. You can hit the "Live test" button next to "Enable redirection to converter?" to verify that this works as just described.

If you (contrary to this headline!) are in fact not on WP Engine, but might want to be, I have an affiliate link for you. It will give you 3 months free and it will give me a reward too, if you should decide to stay there. Here you go: [Get 3 months free when you sign up for WP Engine.](https://shareasale.com/r.cfm?b=1343154&u=2194916&m=41388&urllink=&afftrack=)

### WebP Express / ShortPixel setup
Here is a recipe for using WebP Express together with ShortPixel, such that WebP Express generates the webp's, and ShortPixel only is used to create `<picture>` tags, when it detects a webp image in the same folder as an original.

**There is really no need to do this anymore, because WebP Express is now capable of replacing img tags with picture tags (check out the Alter HTML option)**

You need:
1 x WebP Express
1 x ShortPixel

*1. Setup WebP Express*
If you do not want to use serve varied images:
- Open WebP Express options
- Switch to *CDN friendly* mode.
- Set *File extension* to "Set to .webp"
- Make sure the *Convert non-existing webp-files upon request to original image* option is enabled

If you want to *ShortPixel* to create <picture> tags but still want the magic to work on other images (such as images are referenced from CSS or javascript):
- Open WebP Express options
- Switch to *Varied image responses* mode.
- Set *Destination folder* to "Mingled"
- Set *File extension* to "Set to .webp"

*2. Setup ShortPixel*
- Install [ShortPixel](https://wordpress.org/plugins/shortpixel-image-optimiser/) the usual way
- Get an API key and enter it on the options page.
- In *Advanced*, enable the following options:
    - *Also create WebP versions of the images, for free.*
    - *Deliver the WebP versions of the images in the front-end*
    - *Altering the page code, using the <PICTURE> tag syntax*
- As there is a limit to how many images you can convert freely with *ShortPixel*, you should disable the following options (also on the *Advanced* screen):
    - *Automatically optimize images added by users in front end.*
    - *Automatically optimize Media Library items after they are uploaded (recommended).*

*3. Visit a page*
As there are presumably no webps generated yet, ShortPixel will not generate `<picture>` tags on the first visit. However, the images that are referenced causes the WebP Express *Auto convert* feature to kick in and generate webp images for each image on that page.

*4. Visit the page again*
As *WebP Express* have generated webps in the same folder as the originals, *ShortPixel* detects these, and you should see `<picture>` tags which references the webp's.

*ShortPixel or Cache Enabler ?*
Cache Enabler has the advantage over ShortPixel that the HTML structure remains the same. With ShortPixel, image tags are wrapped in a `<picture>` tag structure, and by doing that, there is a risk of breaking styles.

Further, Cache Enabler *caches* the HTML. This is good for performance. However, this also locks you to using that plugin for caching. With ShortPixel, you can keep using your favourite caching plugin.

Cache Enabler will not work if you are caching HTML on a CDN, because the HTML varies depending on the *Accept* header and it doesn't signal this with a Vary:Accept header. You could however add that manually. ShortPixel does not have that issue, as the HTML is the same for all.

### WebP Express / Cache Enabler setup
The WebP Express / Cache Enabler setup is quite potent and very CDN-friendly. *Cache Enabler* is used for generating *and caching* two versions of the HTML (one for webp-enabled browsers and one for webp-disabled browsers)

The reason for doing this could be:
1. You are using a CDN which cannot be configured to work in the "Varied image responses" mode.
2. You could tweak your CDN to work in the "Varied image responses" mode, but you would have to do it by using the entire Accept header as key. Doing that would increase the risk of cache MISS, and you therefore decided that do not want to do that.
3. You think it is problematic that when a user saves an image, it has the jpg extension, even though it is a webp image.

You need:
1 x WebP Express
1 x Cache Enabler

*1. Setup WebP Express*
If you do not want to use serve varied images:
- Open WebP Express options
- Switch to *CDN friendly* mode.
- Set *File extension* to "Set to .webp"
- Enable *Alter HTML* and select *Replace image URLs*. It is not absolutely necessary, as Cache Enabler also alters HTML - but there are several reasons to do it. Firstly, *Cache Enabler* doesn't get as many URLs replaced as we do. WebP Express for example also replaces background urls in inline styles. Secondly, *Cache enabler* has [problems in edge cases](https://regexr.com/46isf). Thirdly, WebP Express can be configured to alter HTML to point to corresponding webp images, *before they even exists* which can be used in conjunction with the the *Convert non-existing webp-files upon request* option. And this is smart, because then you don't have trouble with *Cache Enabler* caching HTML which references the original images due to that some images hasn't been converted yet.
- If you enabled *Alter HTML*, also enable *Reference webps that hasn't been converted yet* and *Convert non-existing webp-files upon request*
- If you did not enable *Alter HTML*, enable *Convert non-existing webp-files upon request to original image*

If you want to *Cache Enabler* to create <picture> tags but still want the magic to work on other images (such as images are referenced from CSS or javascript):
- Open WebP Express options
- Switch to *Varied image responses* mode.
- Set *Destination folder* to "Mingled"
- Set *File extension* to "Set to .webp"
- I suggest you enable *Alter HTML* and select *Replace image URLs*. And also enable *Reference webps that hasn't been converted yet* and *Convert non-existing webp-files upon request*.

*2. Setup Cache Enabler*
- Open the options
- Enable of the *Create an additional cached version for WebP image support* option

*3. If you did not enable Alter HTML and Reference webps that hasn't been converted yet: Let rise in a warm place until doubled*
*WebP Express* creates *webp* images on need basis. It needs page visits in order to do the conversions . Bulk conversion is on the roadmap, but until then, you need to visit all pages of relevance. You can either do it manually, let your visitors do it (that is: wait a bit), or, if you are on linux, you can use `wget` to grab your website:

```
wget -e robots=off -r -np -w 2 http://www.example.com
```

**flags:**
`-e robots=off` makes wget ignore rules in robots.txt
`-np` (no-parent) makes wget stay within the boundaries (doesn't go into parent folders)
`w 2` Waits two seconds between each request, in order not to stress the server

*4. Clear the Cache Enabler cache.*
Click the "Clear Cache" button in the top right corner in order to clear the Cache Enabler cache.

*5. Inspect the HTML*
When visiting a page with images on, different HTML will be served to browsers, depending on whether they support webp or not.

In a webp-enabled browser, the HTML may look like this: `<img src="image.webp">`, while in a non-webp enabled browser, it looks like this: `<img src="image.jpg">`


*6. Optionally add Cache Enabler rewrite rules in your .htaccess*
*Cache Enabler* provides some rewrite rules that redirects to the cached file directly in the `.htaccess`, bypassing PHP entirely. Their plugin doesn't do that for you, so you will have to do it manually in order to get the best performance. The rules are in the "Advanced configuration" section on [this page](https://www.keycdn.com/support/wordpress-cache-enabler-plugin).


### Does it work with lazy loaded images?
No plugins/frameworks has yet been discovered, which does not work with *WebP Express*.

The most common way of lazy-loading is by setting a *data-src* attribute on the image and let javascript use that value for setting the *src* attribute. That method works, as the image request, seen from the server side, is indistinguishable from any other image request. It could however be that some obscure lazy load implementation would load the image with an XHR request. In that case, the *Accept* header will not contain 'image/webp', but '*/*', and a jpeg will be served, even though the browser supports webp.

The following lazy load plugins/frameworks has been tested and works with *WebP Express*:
- [BJ Lazy Load](https://da.wordpress.org/plugins/bj-lazy-load/)
- [Owl Carousel 2](https://owlcarousel2.github.io/OwlCarousel2/)
- [Lazy Load by WP Rocket](https://wordpress.org/plugins/rocket-lazy-load/)

I have only tested the above in *Varied image responses* mode, but it should also work in *CDN friendly* mode. Both *Alter HTML* options have been designed to work with standard lazy load attributes.

### Can I make an exceptions for some images?
There can be instances where you actually need to serve a jpeg or png. For example if you are demonstrating how a jpeg looks using some compression settings. It is possible to bypass both the redirection and the HTML altering for certain images. Here is how:

*Alter HTML*
Alter HTML is programmed not to substitute image URLs with query strings (better safe than sorry). You can exploit that and simply add ie ?original to the image URLs in question.

*Redirection*
To bypass the *redirection*, you can add the following in the `.htaccess` where *WebP Express* has placed its rules (this is usually in the `wp-content` folder). The rules needs to be added *above* the rules inserted by *WebP Express*.

```
RewriteCond %{QUERY_STRING} original
RewriteCond %{REQUEST_FILENAME} -f
RewriteRule . - [L]
```
With those rules in place, you can add "?original" to the URLs of those images that you want to keep serving as jpg / png.

Alternatively, you can specify the filenames individually in the `.htaccess`:

```
RewriteRule ^uploads/2019/02/example-of-jpg-compressed-to-80\.jpg - [L]
RewriteRule ^uploads/2019/02/image2\.jpg - [L]
RewriteRule . - [L]
```
If you got any further questions, look at, or comment on [this topic](https://wordpress.org/support/topic/can-i-make-an-exception-for-specific-post-image/)

### Update failed and cannot reinstall
The 0.17.0 release contained binaries with dots in their filenames, which caused the unpacking during update to fail on a few systems. This failure could leave an incomplete installation. With important files missing - such as the main plugin file - Wordpress no longer registers that the plugin is there (it is missing from the list). However, the folder is there in the file system and trying to install WebP Express again fails because Wordpress complains about just that. The solution is to remove the "webp-express" folder in "plugins" manually (via ftp or a plugin, such as File Manager) and then install WebP Express anew. The setting will be intact. The filenames that caused the trouble where fixed in 0.17.2.

### When is feature X coming? / Roadmap
No schedule. I move forward as time allows. I currently spend a lot of time answering questions in the support forum. If someone would be nice and help out answering questions here, it would allow me to spend that time developing. Also, donations would allow me to turn down some of the more boring requests from my customers, and speed things up here.

Here are my current plans ahead: 0.17 will probably be a file manager-like interface for converting / bulk converting / viewing conversion logs / comparing original vs webp visually - kind of a merge of current "test converter" and "bulk conversion" interfaces, and with an addition of a file explorer. 0.18 might allow excluding certain files and folders. 0.19 could be supporting Save-Data header in Varied Image Responses mode (send extra compressed images to clients who wants to use as little bandwidth as possible). 0.19 might be displaying rules for NGINX. 0.20 might be an effort to allow webp for all browsers using [this javascript library](http://libwebpjs.hohenlimburg.org/v0.6.0/). Unfortunately, the javascript librare does not (currently) support srcset attributes, which is why I moved this item down the priority list. We need srcset to be supported for the feature to be useful. 0.21 might be WAMP support. The current milestones, their subtasks and their progress can be viewed here: https://github.com/rosell-dk/webp-express/milestones

If you wish to affect priorities, it is certainly possible. You can try to argue your case in the forum or you can simply let the money do the talking. By donating as little as a cup of coffee on [ko-fi.com/rosell](https://ko-fi.com/rosell), you can leave a wish. I shall take these wishes into account when prioritizing between new features.

## Changes in 0.17.5
*(released: 11 Aug 2020)*

* Fixed "Path is outside resolved document root" in a certain symlinked configuration. Thanks to @robertgres for providing the fix.
* Added content filtering hooks for several third party plugins including ACF and WooCommerce Product Images. With this change, the "Use content filtering hooks" in Alter HTML works in more scenarios, which means there are fewer scenarios where you have to resort to the slower "The complete page" option. Thanks to alextuan for providing the contribution
* Fixed problems with Alter HTML when migrating: Absolute paths were cached in the database and the cache was only updated upon saving settings. The paths are not cached anymore (recalculating these on each page load is not a performance problem)

For more info, see the closed issues on the 0.17.5 milestone on the github repository: https://github.com/rosell-dk/webp-express/milestone/30?closed=1

## Changes in 0.17.4
*(released: 26 Jun 2020)*

* Fixed bug: Configuration was repeatedly resetting for some users
* Fixed "Path is outside resolved document root" on file conversion attempts in Windows. Thanks to @Ruzgfpegk from Japan for providing the fix.
* Fix errors not caught in the selftest. Thanks to Benji Bilheimer from Germany providing the fix.
* Fix errors not caught in the selftest with unverified certificates. Thanks to Rikesh Ramlochund from Mauritius for providing the fix.
* Fixed errors with filenames containing encoded symbols. Thanks to Eddie Zhou from Canada for the fix.

For more info, see the closed issues on the 0.17.4 milestone on the github repository: https://github.com/rosell-dk/webp-express/milestone/32?closed=1

## Changes in 0.17.3
*(released: 3 Feb 2020)*

* Fixed critical bug: Fatal error after updating plugin (if one had been postponing updating WebP Express for a while and then updated Wordpress and THEN updated WebP Express)
* A critical bug was fixed in the webp-convert library (PHP 7.4 related)
* A critical bug was fixed in dom-util-for-webp library (PHP 7.4 related)
* Alter HTML now processes the "poster" attribute in Video tags. Thanks to @MikhailRoot from Russia for the PR on github.
* On some Litespeed hosts, WebP Express reported that mod_headers was not available even though it was. Thanks to @lubieowoce from Poland for the PR on github)

For more info, see the closed issues on the 0.17.3 milestone on the github repository: https://github.com/rosell-dk/webp-express/milestone/31?closed=1

## Changes in 0.17.2
*(released: 5 Oct 2019)*

* Fixed bug: Updating plugin failed on some systems (in the unzip phase). Problem was introduced in 0.17.0 with the updated binaries.
* Fixed bug: Alter HTML used the protocol (http/https) for the site for generated links (rather than keeping the protocol for the link). Thanks to Jacob Gullberg from Sweden for discovering this bug.

If you experienced update problems due to the update bug, you will probably be left with an incomplete installation. Some of the plugin files are there, but not all. Especially, the main plugin file (webp-express.php) is missing, which means that Wordpress don't "see" the plugin (it is missing from the list). Trying to install WebP Express again will probably not work, because the "webp-express" folder is already there. You will then have to remove the "webp-express" folder in "plugins" manually (via ftp or a plugin, such as File Manager).

For more info, see the closed issues on the 0.17.2 milestone on the github repository: https://github.com/rosell-dk/webp-express/milestone/29?closed=1

## Changes in 0.17.1
*(released: 3 Oct 2019)*

- Fixed NGINX rules in FAQ (added xdestination for the create webp upon request functionality)
- Fixed issue with Alter HTML. Thanks to @jonathanernst for discovering issue and supplying the patch.
- WebP Express now works on WP Engine. Check out the new "I am on WP Engine" section in the FAQ
- Miscellaneous bug fixes

For more info, see the closed issues on the 0.17.1 milestone on the github repository: https://github.com/rosell-dk/webp-express/milestone/27?closed=1

## Changes in 0.17.0
*(released: 27 sep 2019)*

* Cwebp conversion method runs on more systems (not subject to open_basedir restrictions and also tries "pure" cwebp command). Thanks to cng11 for reaching out so I spotted this.
* Ewww conversion method no longer does a remote api-key check for each conversion - so it is faster. If an ewww conversions fails due to a non-functional key, the key will not be tried again (until next time the options are saved)
* Updated cwebp binaries to version 1.0.3

## Changes in 0.16.0
*(released: 24 sep 2019)*

- Added option to specify CDN urls in Alter HTML. Thanks to Gunnar Peipman from Estonia for suggesting this.
- Direct Nginx users to Nginx FAQ section on welcome page
- Fixed Bulk Conversion halting due to nonce expiry
- Fixed unexpected output upon reactivation
- Added affiliate link to [Optimole](https://optimole.pxf.io/20b0M) in the "Don't despair - You have options!" message

## Changes in 0.15.3
*(released: 19 sep 2019)*

* Fixed fatal error upon activation for systems which cannot use document root for structuring (rare)

## Changes in 0.15.2

* Fixed the bug when File extension was set to "Set to .webp". It was buggy when file extension contained uppercase letters.

## Changes in 0.15.1
*(released: 17 sep 2019)*

- Bug alert: Added alert about a bug when destination folder is set to "mingled" and File extension is set to "Set to .webp"
- Bugfix: Plugin URL pointed to webpexpress - it should point to parent. This gave trouble with images located in plugins. Thanks to Guillaume Meyer from Switzerland for discovering and reporting.
- Bugfix: Images with uppercase chars in extension did not get Vary:Accept
- Bugfix: There were issues with "All content" and destination:document-root when webp-realizer is activated


## Changes in 0.15.0
*(released: 17 sep 2019)*

- Provided test-buttons for checking if the redirects works.
- You can now choose which folders WebP Express is active in. Ie "Uploads and Themes".
- You can now choose an alternative file structure for the webps which does not rely on DOCUMENT_ROOT being available.
- WebP Express can now handle when wp-content is symlinked.
- The .htaccess rules are now divided across folders. Some rules are needed where the source files are located, some where the webp files are located.
- Added option to convert only PNG files
- And a couple of bugfixes.

## Changes in 0.14.12 - 0.14.15
- Fixed errors with "redirect to conversion script" on systems with symlinked folders
- Fixed errors with "redirect to conversion script" on systems where the filename cannot be passed through an environment variable

## Changes in 0.14.5 - 0.14.11
The following security fixes has been applied in 0.14.0 - 0.14.11:
It is urged that you upgrade all of you WebP Express installations!

- Security fix: Closed a security hole that could be used to view the content of any file on the server (provided that the full path is known or guessed). This is a very serious flaw, which unfortunately has been around for quite a while.
- Security fix: Added capability checks to options page.
- Security fix: Sanitized user input.
- Security fix: Added checks for file paths and directories.
- Security fix: Nonces and capability checks for AJAX calls.

## Changes in 0.14.4
- Now bundles with multiple cwebp binaries for linux for systems where 1.0.2 fails.

## Changes in 0.14.3
- Fixed filename of supplied cwebp for linux (bug was introduced in 0.14.2)

## Changes in 0.14.2
- Fixed problem with older versions of cwebp
- Fixed that images was not deleted
- Fixed cache problem on options page on systems that disables cache busting (it resulted in "SyntaxError: JSON.parse")

## Changes in 0.14.1
- A little something

## Changes in 0.14.0
- Security fix: Closed a security hole that could be used to view the content of any file on the server (provided that the full path is known or guessed). This is a very serious flaw, which has been around for quite a while. I urge you to upgrade to 0.14.0.
- Added new "encoding" option, which can be set to auto. This can in some cases dramatically reduce the size of the webp. It is supported by all converters except ewww and gd.
- Added new "near-lossless" option (only for cwebp and vips). Using this is a good idea for reducing size of lossless webps with an acceptable loss of quality
- Added new "alpha-quality" option (all converters, except ewww and gd). Using this is a good idea when images with transparency are converted to lossy webp - it has the potential to reduce the size up to 50% (depending on the source material) while keeping an acceptable level of quality
- Added new conversion methods: Vips and GraphicsMagick
- Imagick conversion method now supports webp options (finally cracked it!)
- Using MimeType detection instead of relying on file extensions
- In "test" converter you now change options and also test PNG files
- Added conversion logs
- PNGs are now enabled by default (with the new conversion features especially PNGs are compressed much better)

For more info, see the closed issues on the 0.14.0 milestone on the github repository: https://github.com/rosell-dk/webp-express/milestone/9?closed=1

## Changes in 0.13.2
- Fixed Fatal error on image upload in combination with the [Enable Media Replace](https://de.wordpress.org/plugins/enable-media-replace/) plugin. Thanks to Alexander Graef from Germany for reporting.
- It seems we finally nailed the blank settings page bug. Thanks to all involved, especially Richard Spenceley from the UK

## Changes in 0.13.1
- Fixed several bugs.

## Changes in 0.13.0
- Bulk Conversion
- Fixed problems with Gd converter and PNG
- Optinally auto convert upon media upload
- Windows fix (thanks, lwxbr!)

## Changes in 0.12.0
- Multisite support (!)
- A new operation mode: "No conversion", if you do not want to use WebP Express for converting. Replaces the old "Just redirect" mode
- Added capability testing of .htaccess. The .htaccess rules are now tailored to the capabilities on the system. For example, on some platforms the filename of a requested image is passed to the converter script through the query string, but on platforms that supports passing it through an environment variable, that method is used instead
- Picturefill.js is now optional (alter html, picture tag)
- A great bunch more!

For more info, see the closed issues on the 0.12.0 milestone on the github repository: https://github.com/rosell-dk/webp-express/milestone/12?closed=1

## Changes in 0.11.0
- Alter HTML to point to webp files (choose between picture tags or simply altering all image urls)
- Convert non-existing webp-files upon request (means you can reference the converted webp files before they are actually converted!)

## Changes in 0.10.0
- Introduced "Operation modes" in order to keep setting screens simple but still allow tweaking
- WebP Express can now be used in conjunction with Cache Enabler and ShortPixel
- Cache-Control header is now added in *.htaccess*, when redirecting directly to existing webp

## Changes in 0.9.0
- Optionally make .htaccess redirect directly to existing webp (improves performance)
- Optionally do not send filename from .htaccess to the PHP in Querystring, but use other means (improves security and reduces risks of problems due to firewall rules)
- Fixed some bugs

For more info, see the closed issues on the 0.9.0 milestone on the github repository: https://github.com/rosell-dk/webp-express/issues?q=is%3Aclosed+milestone%3A0.9.0

## Supporting WebP Express
Bread on the table don't come for free, even though this plugin does, and always will. I enjoy developing this, and supporting you guys, but I kind of need the bread too. Please make it possible for me to continue putting effort into this plugin:

- [Buy me a Coffee](https://ko-fi.com/rosell)
- [Become a backer](https://github.com/rosell-dk/webp-express/blob/master/BACKERS.md)
