<?php
/*
Plugin Name: Woocommerce Import
Plugin URI:  http://www.yndenz.com
Description: The basics to convert your own product feed into WooCommerce products and categories 
Version:     1.1
Author:      Gido Manders <g.manders@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: woocommerce-import
*/

add_action('init', 'check_woocommerce_multilingual_version');
function check_woocommerce_multilingual_version() {
    $woocommerce_multilingual_data = get_plugin_data(dirname(dirname(__FILE__)) . '/woocommerce-multilingual/wpml-woocommerce.php');
    if (version_compare($woocommerce_multilingual_data['Version'], '4.1', '>=')) {
        add_action('admin_notices', 'woocommerce_multilingual_version_notice');
    }
}

function woocommerce_multilingual_version_notice() {
    ?>
    <div class="notice notice-error is-dismissible">
        <p><?php _e( 'WooCommerce Import is niet compatibel met WooCommerce Multilingual versie 4.1 en hoger', 'woocommerce-import' ); ?></p>
    </div>
    <?php
}


/**
 * Add a menu item to the settings menu
 */
add_action('admin_menu', 'woocommerce_import_menu');
function woocommerce_import_menu() {
	// Add a new submenu under Settings
    add_submenu_page( 'edit.php?post_type=product', __( 'Import', 'woocommerce' ), __( 'Import', 'woocommerce' ), 'manage_options', 'import', 'woocommerce_import_settings_page' );

	add_action('admin_init', 'register_woocommerce_import_settings');
}

/**
 * Register settings
 */
function register_woocommerce_import_settings() {
	//register our settings
	register_setting('woocommerce-import-settings', 'woocommerce_languages');
	register_setting('woocommerce-import-settings', 'woocommerce_default_language');
}

/**
 * Display the settings page
 */
function woocommerce_import_settings_page() {
	// Must check that the user has the required capability
	if (!current_user_can('manage_options')) {
		wp_die(__('You do not have sufficient permissions to access this page.'));
	}

	// See if the user has saved the settings
	if (isset($_POST['save-settings'])) {
		// Save the posted value in the database
		update_option('woocommerce_languages', $_POST['woocommerce_languages']);
		update_option('woocommerce_default_language', $_POST['woocommerce_default_language']);
		?>
		<div class="updated">
			<p>
				<strong><?php _e('Instellingen opgeslagen.', 'woocommerce-import'); ?></strong>
			</p>
		</div>
		<?php
	}
	?>
	<div class="wrap">
		<h1><?php _e('Import', 'woocommerce-import'); ?></h1>
		<form name="woocommerceImportSettingsForm" method="post" action="">
			<table class="form-table">
				<tr>
					<th scope="row">
						<label for="woocommerce_languages">
							<?php _e('Beschikbare talen:', 'woocommerce-import'); ?>
						</label>
					</th>
					<td>
						<input type="text" name="woocommerce_languages" id="woocommerce_languages"
						       value="<?php echo get_option('woocommerce_languages'); ?>"/>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="woocommerce_default_language">
							<?php _e('Standaard taal:', 'woocommerce-import'); ?>
						</label>
					</th>
					<td>
						<input type="text" name="woocommerce_default_language" id="woocommerce_default_language"
						       value="<?php echo get_option('woocommerce_default_language'); ?>"/>
					</td>
				</tr>
			</table>
			<p class="submit">
				<input type="submit" class="button button-primary" name="save-settings" id="save-settings"
				       value="<?php _e('Opslaan', 'woocommerce-import'); ?>"/>
			</p>
		</form>
	</div>
	<?php

    do_action('woocommerce_import_after_settings');
}

require_once 'Converter.class.php';
require_once 'CategoryConverter.class.php';
require_once 'ProductConverter.class.php';