<?php

namespace WC_Import;

define('WC_API_LOCATION', WP_PLUGIN_DIR . '/woocommerce/includes/api/legacy/v3');
require_once WC_API_LOCATION . '/class-wc-api-exception.php';
require_once WC_API_LOCATION . '/class-wc-api-server.php';
require_once WC_API_LOCATION . '/class-wc-api-resource.php';
require_once WC_API_LOCATION . '/interface-wc-api-handler.php';
require_once WC_API_LOCATION . '/class-wc-api-json-handler.php';
require_once WC_API_LOCATION . '/class-wc-api-products.php';

use WC_API_Products;
use WC_API_Server;

abstract class Converter {

	protected $main_category_id;
	protected $api_products;
	protected $supported_cultures = array();
	protected $default_culture = 'nl-NL';
	protected $counter = 0;

	public function __construct() {
		// Make the WooCommerce API usable
		$server = new WC_API_Server('/wc-api/v3/');
		$this->api_products = new WC_API_Products($server);

		$this->supported_cultures = preg_split('/[\s,;]+/i', get_option('woocommerce_languages'));
		$this->default_culture = get_option('woocommerce_default_language');
	}

	public function get_counter() {
		return $this->counter;
	}

	/**
	 * Check if the total items counter is still accurate
	 * Returns just the given total items counter if the function is not overwritten
	 *
	 * @param int $total_items Total items counter
	 *
	 * @return int New total items counter
	 */
	protected function recheck_total_items($total_items) {
		return $total_items;
	}

	/**
	 * Make a plural word singular
	 *
	 * @param string $string The string to be converted
	 *
	 * @return string The converted string
	 */
	public function singular($string) {
		if (substr($string, - 1, 1) === 's') {
			$string = substr($string, 0, - 1);
		}

		return $string;
	}

}