<?php

namespace WC_Import;

class WC_Import {

    public function __construct() {
        add_action('init', array($this, 'check_woocommerce_multilingual_version'));
        add_action('admin_menu', array($this, 'menu'));
        add_action('admin_init', array($this, 'register_settings'));
    }

    public function check_woocommerce_multilingual_version() {
        $woocommerce_multilingual_data = get_plugin_data(dirname(dirname(__FILE__)) . '/woocommerce-multilingual/wpml-woocommerce.php');
        if (version_compare($woocommerce_multilingual_data['Version'], '4.1', '>=')) {
            add_action('admin_notices', array($this, 'woocommerce_multilingual_version_notice'));
        }
    }

    public function woocommerce_multilingual_version_notice() {
        ?>
        <div class="notice notice-error is-dismissible">
            <p><?php _e('WooCommerce Import is niet compatibel met WooCommerce Multilingual versie 4.1 en hoger', 'woocommerce-import'); ?></p>
        </div>
        <?php
    }

    /**
     * Add a menu item to the settings menu
     */
    public function menu() {
        // Add a new submenu under Settings
        add_submenu_page('edit.php?post_type=product', __('Import', 'woocommerce'), __('Import', 'woocommerce'), 'manage_options', 'import', array($this,
                                                                                                                                                   'settings_page'));
    }

    /**
     * Register settings
     */
    public function register_settings() {
        //register our settings
        register_setting('woocommerce-import-settings', 'woocommerce_languages');
        register_setting('woocommerce-import-settings', 'woocommerce_default_language');
    }

    /**
     * Display the settings page
     */
    function settings_page() {
        // Must check that the user has the required capability
        if (!current_user_can('manage_options')) {
            wp_die(__('You do not have sufficient permissions to access this page.'));
        }

        // See if the user has saved the settings
        if (isset($_POST['save-settings'])) {
            // Save the posted value in the database
            update_option('woocommerce_languages', $_POST['woocommerce_languages']);
            update_option('woocommerce_default_language', $_POST['woocommerce_default_language']);
            ?>
            <div class="updated">
                <p>
                    <strong><?php _e('Instellingen opgeslagen.', 'woocommerce-import'); ?></strong>
                </p>
            </div>
            <?php
        }
        ?>
        <div class="wrap">
            <h1><?php _e('Import', 'woocommerce-import'); ?></h1>
            <form name="woocommerceImportSettingsForm" method="post" action="">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="woocommerce_languages">
                                <?php _e('Beschikbare talen:', 'woocommerce-import'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text" name="woocommerce_languages" id="woocommerce_languages"
                                   value="<?php echo get_option('woocommerce_languages'); ?>"/>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="woocommerce_default_language">
                                <?php _e('Standaard taal:', 'woocommerce-import'); ?>
                            </label>
                        </th>
                        <td>
                            <input type="text" name="woocommerce_default_language" id="woocommerce_default_language"
                                   value="<?php echo get_option('woocommerce_default_language'); ?>"/>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <input type="submit" class="button button-primary" name="save-settings" id="save-settings"
                           value="<?php _e('Opslaan', 'woocommerce-import'); ?>"/>
                </p>
            </form>
        </div>
        <?php
    }
}