<?php

namespace WC_Import;

abstract class Converter {

	protected $main_category_id;
	protected $supported_cultures = array();
	protected $default_culture = 'nl-NL';
	protected $counter = 0;

	public function __construct() {
		$this->supported_cultures = preg_split('/[\s,;]+/i', get_option('woocommerce_languages'));
		$this->default_culture    = get_option('woocommerce_default_language');
	}

	public function get_counter() {
		return $this->counter;
	}

	/**
	 * Check if the total items counter is still accurate
	 */
	protected function recheck_total_items($total_items) {
		return $total_items;
	}

	/**
	 * Make a plural word singular
	 */
	public static function singular($string) {
		if (substr($string, -1) === 's') {
			$string = substr($string, 0, -1);
		}
		return $string;
	}
}
